/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.mapper;

import com.upl.fazorstarclub.domain.Disease;
import com.upl.fazorstarclub.domain.MasterDisease;
import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.service.dto.DiseaseDTO;
import com.upl.fazorstarclub.service.dto.MasterDiseaseDTO;
import com.upl.fazorstarclub.service.mapper.DiseaseMapper;
import com.upl.fazorstarclub.service.mapper.MasterDiseaseMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiseaseMapperImpl
implements DiseaseMapper {
    @Autowired
    private MasterDiseaseMapper masterDiseaseMapper;

    public List<Disease> toEntity(List<DiseaseDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Disease> list = new ArrayList<Disease>(dtoList.size());
        for (DiseaseDTO diseaseDTO : dtoList) {
            list.add(this.toEntity(diseaseDTO));
        }
        return list;
    }

    public List<DiseaseDTO> toDto(List<Disease> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<DiseaseDTO> list = new ArrayList<DiseaseDTO>(entityList.size());
        for (Disease disease : entityList) {
            list.add(this.toDto(disease));
        }
        return list;
    }

    public DiseaseDTO toDto(Disease disease) {
        if (disease == null) {
            return null;
        }
        DiseaseDTO diseaseDTO = new DiseaseDTO();
        diseaseDTO.setUserFarmId(this.diseaseUserFarmId(disease));
        diseaseDTO.setCreatedBy(disease.getCreatedBy());
        diseaseDTO.setCreatedDate(disease.getCreatedDate());
        diseaseDTO.setLastModifiedBy(disease.getLastModifiedBy());
        diseaseDTO.setLastModifiedDate(disease.getLastModifiedDate());
        diseaseDTO.setId(disease.getId());
        diseaseDTO.setName(disease.getName());
        diseaseDTO.setStatus(disease.getStatus());
        diseaseDTO.setLevelOfPressure(this.EnumToString(disease.getLevelOfPressure()));
        diseaseDTO.setMasterDisease((MasterDiseaseDTO)this.masterDiseaseMapper.toDto((Object)disease.getMasterDisease()));
        diseaseDTO.setLatitude(disease.getLatitude());
        diseaseDTO.setLongitude(disease.getLongitude());
        return diseaseDTO;
    }

    public Disease toEntity(DiseaseDTO diseaseDTO) {
        if (diseaseDTO == null) {
            return null;
        }
        Disease disease = new Disease();
        disease.userFarm(this.diseaseDTOToUserFarm(diseaseDTO));
        disease.setCreatedBy(diseaseDTO.getCreatedBy());
        disease.setCreatedDate(diseaseDTO.getCreatedDate());
        disease.setLastModifiedBy(diseaseDTO.getLastModifiedBy());
        disease.setLastModifiedDate(diseaseDTO.getLastModifiedDate());
        disease.setId(diseaseDTO.getId());
        disease.setName(diseaseDTO.getName());
        disease.setStatus(diseaseDTO.getStatus());
        disease.setLatitude(diseaseDTO.getLatitude());
        disease.setLongitude(diseaseDTO.getLongitude());
        disease.setLevelOfPressure(this.StringToEnum(diseaseDTO.getLevelOfPressure()));
        disease.masterDisease((MasterDisease)this.masterDiseaseMapper.toEntity((Object)diseaseDTO.getMasterDisease()));
        return disease;
    }

    private Long diseaseUserFarmId(Disease disease) {
        if (disease == null) {
            return null;
        }
        UserFarm userFarm = disease.getUserFarm();
        if (userFarm == null) {
            return null;
        }
        Long id = userFarm.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected UserFarm diseaseDTOToUserFarm(DiseaseDTO diseaseDTO) {
        if (diseaseDTO == null) {
            return null;
        }
        UserFarm userFarm = new UserFarm();
        userFarm.setId(diseaseDTO.getUserFarmId());
        return userFarm;
    }
}

