/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.mapper;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.DebateComment;
import com.upl.fazorstarclub.domain.Topic;
import com.upl.fazorstarclub.service.dto.DebateCommentDTO;
import com.upl.fazorstarclub.service.mapper.AppUserMapper;
import com.upl.fazorstarclub.service.mapper.DebateCommentMapper;
import com.upl.fazorstarclub.service.mapper.TopicMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DebateCommentMapperImpl
implements DebateCommentMapper {
    @Autowired
    private AppUserMapper appUserMapper;
    @Autowired
    private TopicMapper topicMapper;

    public List<DebateComment> toEntity(List<DebateCommentDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<DebateComment> list = new ArrayList<DebateComment>(dtoList.size());
        for (DebateCommentDTO debateCommentDTO : dtoList) {
            list.add(this.toEntity(debateCommentDTO));
        }
        return list;
    }

    public List<DebateCommentDTO> toDto(List<DebateComment> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<DebateCommentDTO> list = new ArrayList<DebateCommentDTO>(entityList.size());
        for (DebateComment debateComment : entityList) {
            list.add(this.toDto(debateComment));
        }
        return list;
    }

    public DebateCommentDTO toDto(DebateComment debateComment) {
        if (debateComment == null) {
            return null;
        }
        DebateCommentDTO debateCommentDTO = new DebateCommentDTO();
        debateCommentDTO.setReferred(this.debateCommentReferredId(debateComment));
        debateCommentDTO.setAppUserId(this.debateCommentAppUserId(debateComment));
        debateCommentDTO.setTopicId(this.debateCommentTopicId(debateComment));
        debateCommentDTO.setCreatedBy(debateComment.getCreatedBy());
        debateCommentDTO.setCreatedDate(debateComment.getCreatedDate());
        debateCommentDTO.setLastModifiedBy(debateComment.getLastModifiedBy());
        debateCommentDTO.setLastModifiedDate(debateComment.getLastModifiedDate());
        debateCommentDTO.setId(debateComment.getId());
        debateCommentDTO.setStatus(debateComment.getStatus());
        debateCommentDTO.setText(debateComment.getText());
        return debateCommentDTO;
    }

    public DebateComment toEntity(DebateCommentDTO debateCommentDTO) {
        if (debateCommentDTO == null) {
            return null;
        }
        DebateComment debateComment = new DebateComment();
        debateComment.referred(this.fromId(debateCommentDTO.getReferred()));
        debateComment.setAppUser(this.appUserMapper.fromId(debateCommentDTO.getAppUserId()));
        debateComment.setTopic(this.topicMapper.fromId(debateCommentDTO.getTopicId()));
        debateComment.setCreatedBy(debateCommentDTO.getCreatedBy());
        debateComment.setCreatedDate(debateCommentDTO.getCreatedDate());
        debateComment.setLastModifiedBy(debateCommentDTO.getLastModifiedBy());
        debateComment.setLastModifiedDate(debateCommentDTO.getLastModifiedDate());
        debateComment.setId(debateCommentDTO.getId());
        debateComment.setStatus(debateCommentDTO.getStatus());
        debateComment.setText(debateCommentDTO.getText());
        return debateComment;
    }

    private Long debateCommentReferredId(DebateComment debateComment) {
        if (debateComment == null) {
            return null;
        }
        DebateComment referred = debateComment.getReferred();
        if (referred == null) {
            return null;
        }
        Long id = referred.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Long debateCommentAppUserId(DebateComment debateComment) {
        if (debateComment == null) {
            return null;
        }
        AppUser appUser = debateComment.getAppUser();
        if (appUser == null) {
            return null;
        }
        Long id = appUser.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Long debateCommentTopicId(DebateComment debateComment) {
        if (debateComment == null) {
            return null;
        }
        Topic topic = debateComment.getTopic();
        if (topic == null) {
            return null;
        }
        Long id = topic.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

