/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.mapper;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.service.dto.AppUserDTO;
import com.upl.fazorstarclub.service.dto.AppUserShortDTO;
import com.upl.fazorstarclub.service.mapper.AppUserMapper;
import com.upl.fazorstarclub.service.mapper.CountryMapper;
import com.upl.fazorstarclub.service.mapper.StateMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppUserMapperImpl
implements AppUserMapper {
    @Autowired
    private CountryMapper countryMapper;
    @Autowired
    private StateMapper stateMapper;

    public List<AppUser> toEntity(List<AppUserDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<AppUser> list = new ArrayList<AppUser>(dtoList.size());
        for (AppUserDTO appUserDTO : dtoList) {
            list.add(this.toEntity(appUserDTO));
        }
        return list;
    }

    public List<AppUserDTO> toDto(List<AppUser> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<AppUserDTO> list = new ArrayList<AppUserDTO>(entityList.size());
        for (AppUser appUser : entityList) {
            list.add(this.toDto(appUser));
        }
        return list;
    }

    public AppUserDTO toDto(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        AppUserDTO appUserDTO = new AppUserDTO();
        appUserDTO.setCountryId(this.appUserCountryId(appUser));
        appUserDTO.setStateId(this.appUserStateId(appUser));
        appUserDTO.setCountryName(this.appUserCountryName(appUser));
        appUserDTO.setStateName(this.appUserStateName(appUser));
        appUserDTO.setParentId(this.appUserParentId(appUser));
        appUserDTO.setCreatedBy(appUser.getCreatedBy());
        appUserDTO.setCreatedDate(appUser.getCreatedDate());
        appUserDTO.setLastModifiedBy(appUser.getLastModifiedBy());
        appUserDTO.setLastModifiedDate(appUser.getLastModifiedDate());
        appUserDTO.setId(appUser.getId());
        appUserDTO.setEmail(appUser.getEmail());
        appUserDTO.setMobileNumber(appUser.getMobileNumber());
        appUserDTO.setProfilePhotoPath(appUser.getProfilePhotoPath());
        appUserDTO.setRole(this.EnumToString(appUser.getRole()));
        appUserDTO.setStatus(appUser.getStatus());
        appUserDTO.setPincode(appUser.getPincode());
        appUserDTO.setCity(appUser.getCity());
        appUserDTO.setStreet(appUser.getStreet());
        appUserDTO.setLatitude(appUser.getLatitude());
        appUserDTO.setLongitude(appUser.getLongitude());
        appUserDTO.setDistrict(appUser.getDistrict());
        appUserDTO.setUserName(appUser.getUserName());
        appUserDTO.setIdNumber(appUser.getIdNumber());
        appUserDTO.setCompanyName(appUser.getCompanyName());
        appUserDTO.setAddress(appUser.getAddress());
        appUserDTO.setAgreementNumber(appUser.getAgreementNumber());
        return appUserDTO;
    }

    public AppUser toEntity(AppUserDTO appUserDTO) {
        if (appUserDTO == null) {
            return null;
        }
        AppUser appUser = new AppUser();
        appUser.country(this.countryMapper.fromId(appUserDTO.getCountryId()));
        appUser.state(this.stateMapper.fromId(appUserDTO.getStateId()));
        appUser.setParent(this.fromId(appUserDTO.getParentId()));
        appUser.setCreatedBy(appUserDTO.getCreatedBy());
        appUser.setCreatedDate(appUserDTO.getCreatedDate());
        appUser.setLastModifiedBy(appUserDTO.getLastModifiedBy());
        appUser.setLastModifiedDate(appUserDTO.getLastModifiedDate());
        appUser.setId(appUserDTO.getId());
        appUser.setEmail(appUserDTO.getEmail());
        appUser.setPassword(appUserDTO.getPassword());
        appUser.setMobileNumber(appUserDTO.getMobileNumber());
        appUser.setRole(this.StringToEnum(appUserDTO.getRole()));
        appUser.setStatus(appUserDTO.getStatus());
        appUser.setPincode(appUserDTO.getPincode());
        appUser.setCity(appUserDTO.getCity());
        appUser.setStreet(appUserDTO.getStreet());
        appUser.setDistrict(appUserDTO.getDistrict());
        appUser.setLatitude(appUserDTO.getLatitude());
        appUser.setLongitude(appUserDTO.getLongitude());
        appUser.setUserName(appUserDTO.getUserName());
        appUser.setIdNumber(appUserDTO.getIdNumber());
        appUser.setCompanyName(appUserDTO.getCompanyName());
        appUser.setAddress(appUserDTO.getAddress());
        appUser.setAgreementNumber(appUserDTO.getAgreementNumber());
        appUser.setProfilePhotoPath(appUserDTO.getProfilePhotoPath());
        return appUser;
    }

    public List<AppUserShortDTO> toShortDto(List<AppUser> appUsers) {
        if (appUsers == null) {
            return null;
        }
        ArrayList<AppUserShortDTO> list = new ArrayList<AppUserShortDTO>(appUsers.size());
        for (AppUser appUser : appUsers) {
            list.add(this.appUserToAppUserShortDTO(appUser));
        }
        return list;
    }

    private Long appUserCountryId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        Long id = country.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Long appUserStateId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        State state = appUser.getState();
        if (state == null) {
            return null;
        }
        Long id = state.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String appUserCountryName(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        String name = country.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String appUserStateName(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        State state = appUser.getState();
        if (state == null) {
            return null;
        }
        String name = state.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private Long appUserParentId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        AppUser parent = appUser.getParent();
        if (parent == null) {
            return null;
        }
        Long id = parent.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected AppUserShortDTO appUserToAppUserShortDTO(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        AppUserShortDTO appUserShortDTO = new AppUserShortDTO();
        appUserShortDTO.setId(appUser.getId());
        appUserShortDTO.setUserName(appUser.getUserName());
        return appUserShortDTO;
    }
}

