/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.mapper;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.service.dto.AppUserDetailDTO;
import com.upl.fazorstarclub.service.mapper.AppUserDetailMapper;
import com.upl.fazorstarclub.service.mapper.AppUserMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppUserDetailMapperImpl
implements AppUserDetailMapper {
    @Autowired
    private AppUserMapper appUserMapper;

    public AppUserDetailDTO toDetailDto(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        AppUserDetailDTO appUserDetailDTO = new AppUserDetailDTO();
        appUserDetailDTO.setCountryId(this.appUserCountryId(appUser));
        appUserDetailDTO.setCountryName(this.appUserCountryName(appUser));
        appUserDetailDTO.setStateId(this.appUserStateId(appUser));
        appUserDetailDTO.setStateName(this.appUserStateName(appUser));
        appUserDetailDTO.setParentId(this.appUserParentId(appUser));
        appUserDetailDTO.setParentName(this.mapParentName(appUser.getParent()));
        appUserDetailDTO.setTotalReportees(this.mapTotalReportees(appUser.getChildren()));
        appUserDetailDTO.setCreatedBy(appUser.getCreatedBy());
        appUserDetailDTO.setCreatedDate(appUser.getCreatedDate());
        appUserDetailDTO.setLastModifiedBy(appUser.getLastModifiedBy());
        appUserDetailDTO.setLastModifiedDate(appUser.getLastModifiedDate());
        appUserDetailDTO.setId(appUser.getId());
        appUserDetailDTO.setEmail(appUser.getEmail());
        appUserDetailDTO.setMobileNumber(appUser.getMobileNumber());
        appUserDetailDTO.setProfilePhotoPath(appUser.getProfilePhotoPath());
        appUserDetailDTO.setRole(this.appUserMapper.EnumToString(appUser.getRole()));
        appUserDetailDTO.setStatus(appUser.getStatus());
        appUserDetailDTO.setPincode(appUser.getPincode());
        appUserDetailDTO.setCity(appUser.getCity());
        appUserDetailDTO.setStreet(appUser.getStreet());
        appUserDetailDTO.setLatitude(appUser.getLatitude());
        appUserDetailDTO.setLongitude(appUser.getLongitude());
        appUserDetailDTO.setDistrict(appUser.getDistrict());
        appUserDetailDTO.setUserName(appUser.getUserName());
        appUserDetailDTO.setIdNumber(appUser.getIdNumber());
        appUserDetailDTO.setCompanyName(appUser.getCompanyName());
        appUserDetailDTO.setAddress(appUser.getAddress());
        appUserDetailDTO.setAgreementNumber(appUser.getAgreementNumber());
        return appUserDetailDTO;
    }

    public List<AppUserDetailDTO> toDto(List<AppUser> collect) {
        if (collect == null) {
            return null;
        }
        ArrayList<AppUserDetailDTO> list = new ArrayList<AppUserDetailDTO>(collect.size());
        for (AppUser appUser : collect) {
            list.add(this.toDetailDto(appUser));
        }
        return list;
    }

    private Long appUserCountryId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        Long id = country.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String appUserCountryName(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        String name = country.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private Long appUserStateId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        State state = appUser.getState();
        if (state == null) {
            return null;
        }
        Long id = state.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String appUserStateName(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        State state = appUser.getState();
        if (state == null) {
            return null;
        }
        String name = state.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private Long appUserParentId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        AppUser parent = appUser.getParent();
        if (parent == null) {
            return null;
        }
        Long id = parent.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

