/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.DataCollection;
import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.domain.Weather;
import com.upl.fazorstarclub.repository.DataCollectionRepository;
import com.upl.fazorstarclub.repository.UserFarmRepository;
import com.upl.fazorstarclub.repository.WeatherRepository;
import com.upl.fazorstarclub.service.WeatherService;
import com.upl.fazorstarclub.service.dto.UserFarmWeatherCurrentDetailDTO;
import com.upl.fazorstarclub.service.dto.UserFarmWeatherDetailDTO;
import com.upl.fazorstarclub.service.dto.UserFarmWeatherHistoryDetailDTO;
import com.upl.fazorstarclub.service.dto.WeatherDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.mapper.WeatherMapper;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.service.utility.WeatherUtility;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WeatherServiceImpl
implements WeatherService {
    private final Logger log = LoggerFactory.getLogger(WeatherServiceImpl.class);
    private final WeatherRepository weatherRepository;
    private final WeatherMapper weatherMapper;
    @Autowired
    private WeatherUtility weatherUtility;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private UserFarmRepository userFarmRepository;
    @Autowired
    private DataCollectionRepository dataCollectionRepository;

    public WeatherServiceImpl(WeatherRepository weatherRepository, WeatherMapper weatherMapper) {
        this.weatherRepository = weatherRepository;
        this.weatherMapper = weatherMapper;
    }

    public WeatherDTO save(WeatherDTO weatherDTO) {
        this.log.debug("Request to save Weather : {}", (Object)weatherDTO);
        Weather weather = (Weather)this.weatherMapper.toEntity((Object)weatherDTO);
        weather = (Weather)this.weatherRepository.save((Object)weather);
        return (WeatherDTO)this.weatherMapper.toDto((Object)weather);
    }

    @Transactional(readOnly=true)
    public Page<WeatherDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Weathers");
        return this.weatherRepository.findAll(pageable).map(arg_0 -> ((WeatherMapper)this.weatherMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<WeatherDTO> findOne(Long id) {
        this.log.debug("Request to get Weather : {}", (Object)id);
        return this.weatherRepository.findById((Object)id).map(arg_0 -> ((WeatherMapper)this.weatherMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Weather : {}", (Object)id);
        this.weatherRepository.deleteById((Object)id);
    }

    public List<UserFarmWeatherDetailDTO> getWeatherHistory(Long userFarmId, String startDate, String endDate) {
        ArrayList<UserFarmWeatherDetailDTO> userFarmWeatherDetailDTO = new ArrayList<UserFarmWeatherDetailDTO>();
        Optional userFarm = this.userFarmRepository.findByIdAndStatus(userFarmId, Boolean.valueOf(true));
        try {
            List userFarmWeatherHistoryDetailDTOs = null;
            userFarmWeatherHistoryDetailDTOs = StringUtils.isBlank((CharSequence)startDate) && StringUtils.isBlank((CharSequence)endDate) ? this.weatherUtility.fetchWeatherHistoryDetails(((UserFarm)userFarm.get()).getLatitude(), ((UserFarm)userFarm.get()).getLongitude(), LocalDate.now().minusYears(1L).toString(), LocalDate.now().toString()) : this.weatherUtility.fetchWeatherHistoryDetails(((UserFarm)userFarm.get()).getLatitude(), ((UserFarm)userFarm.get()).getLongitude(), startDate, endDate);
            for (UserFarmWeatherHistoryDetailDTO userFarmWeatherHistoryDetailDTO : userFarmWeatherHistoryDetailDTOs) {
                userFarmWeatherDetailDTO.add(this.weatherUtility.convHistoryToWeatherDetailDTO(userFarmWeatherHistoryDetailDTO, ((UserFarm)userFarm.get()).getLatitude(), ((UserFarm)userFarm.get()).getLongitude(), (UserFarm)userFarm.get()));
            }
        }
        catch (Exception e) {
            this.log.error("error while fetching history weather data ", (Throwable)e);
            String message = this.i18nUtility.getMessage("weatherService.weather.history.exception", null);
            throw new BadRequestException(message);
        }
        return userFarmWeatherDetailDTO;
    }

    public List<UserFarmWeatherDetailDTO> getWeatherForecast(Long userFarmId) {
        try {
            Optional userFarm = null;
            if (userFarmId != null) {
                userFarm = this.userFarmRepository.findByIdAndStatus(userFarmId, Boolean.valueOf(true));
            }
            List userFieldWeatherDetailDTOs = this.weatherUtility.fetchWeatherForcastDetails((UserFarm)userFarm.get());
            return this.updateWeatherWindowColor(userFieldWeatherDetailDTOs, userFarmId);
        }
        catch (Exception e) {
            this.log.error("Weather forecast Data Not Found. " + e);
            String message = this.i18nUtility.getMessage("weatherService.weather.forecast.exception", null);
            throw new BadRequestException(message);
        }
    }

    private List<UserFarmWeatherDetailDTO> updateWeatherWindowColor(List<UserFarmWeatherDetailDTO> userFarmWeatherDetailDTOs, Long userFarmId) {
        Optional dataCollection = this.dataCollectionRepository.findTopByUserFarmIdOrderByCreatedDateDesc(userFarmId);
        for (UserFarmWeatherDetailDTO userFarmWeatherDetailDTO : userFarmWeatherDetailDTOs) {
            if (dataCollection.isPresent()) {
                userFarmWeatherDetailDTO.setEmergencePercetage25mm(((DataCollection)dataCollection.get()).getTuberPlant25mmPercentage());
                userFarmWeatherDetailDTO.setEmergencePercetage35mm(((DataCollection)dataCollection.get()).getTuberPlant35mmPercentage());
            }
            if (userFarmWeatherDetailDTO.getPrecip() <= 1.0) {
                userFarmWeatherDetailDTO.setGreenWindowColor(Boolean.valueOf(true));
                userFarmWeatherDetailDTO.setRedWindowColor(Boolean.valueOf(false));
                userFarmWeatherDetailDTO.setOrangeWindowColor(Boolean.valueOf(false));
                continue;
            }
            if (userFarmWeatherDetailDTO.getPrecip() > 5.0) {
                userFarmWeatherDetailDTO.setRedWindowColor(Boolean.valueOf(true));
                userFarmWeatherDetailDTO.setGreenWindowColor(Boolean.valueOf(false));
                userFarmWeatherDetailDTO.setOrangeWindowColor(Boolean.valueOf(false));
                continue;
            }
            if (!(userFarmWeatherDetailDTO.getPrecip() > 1.0) || !(userFarmWeatherDetailDTO.getPrecip() < 5.0)) continue;
            userFarmWeatherDetailDTO.setOrangeWindowColor(Boolean.valueOf(true));
            userFarmWeatherDetailDTO.setRedWindowColor(Boolean.valueOf(false));
            userFarmWeatherDetailDTO.setGreenWindowColor(Boolean.valueOf(false));
        }
        return userFarmWeatherDetailDTOs;
    }

    public List<UserFarmWeatherCurrentDetailDTO> getWeatherCurrent(Long userFarmId) {
        try {
            Optional userFarm = null;
            if (userFarmId != null) {
                userFarm = this.userFarmRepository.findByIdAndStatus(userFarmId, Boolean.valueOf(true));
            }
            List userFieldWeatherDetailDTOs = this.weatherUtility.fetchWeatherCurrentDetails((UserFarm)userFarm.get());
            return userFieldWeatherDetailDTOs;
        }
        catch (Exception e) {
            this.log.error("Weather current Data Not Found. " + e);
            String message = this.i18nUtility.getMessage("weatherService.weather.current.exception", null);
            throw new BadRequestException(message);
        }
    }
}

