/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.DataCollection;
import com.upl.fazorstarclub.domain.ProductApplication;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.repository.CountryRepository;
import com.upl.fazorstarclub.repository.DataCollectionRepository;
import com.upl.fazorstarclub.repository.DiseaseRepository;
import com.upl.fazorstarclub.repository.PestRepository;
import com.upl.fazorstarclub.repository.ProductApplicationRepository;
import com.upl.fazorstarclub.repository.StateRepository;
import com.upl.fazorstarclub.repository.UserFarmRepository;
import com.upl.fazorstarclub.service.UserFarmService;
import com.upl.fazorstarclub.service.dto.DiseaseDTO;
import com.upl.fazorstarclub.service.dto.HistoryResponseDTO;
import com.upl.fazorstarclub.service.dto.ObservationMapResponseDTO;
import com.upl.fazorstarclub.service.dto.PestDTO;
import com.upl.fazorstarclub.service.dto.UserFarmDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.mapper.DataCollectionMapper;
import com.upl.fazorstarclub.service.mapper.DiseaseMapper;
import com.upl.fazorstarclub.service.mapper.PestMapper;
import com.upl.fazorstarclub.service.mapper.UserFarmMapper;
import com.upl.fazorstarclub.service.utility.GeoUtility;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserFarmServiceImpl
implements UserFarmService {
    private final Logger log = LoggerFactory.getLogger(UserFarmServiceImpl.class);
    private final UserFarmRepository userFarmRepository;
    private final UserFarmMapper userFarmMapper;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private GeoUtility geoUtility;
    @Autowired
    private CountryRepository countryRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private DataCollectionRepository dataCollectionRepository;
    @Autowired
    private DiseaseRepository diseaseRepository;
    @Autowired
    private PestRepository pestRepository;
    @Autowired
    private ProductApplicationRepository productApplicationRepository;
    private final DataCollectionMapper dataCollectionMapper;
    private final DiseaseMapper diseaseMapper;
    private final PestMapper pestMapper;

    public UserFarmServiceImpl(UserFarmRepository userFarmRepository, UserFarmMapper userFarmMapper, DataCollectionMapper dataCollectionMapper, PestMapper pestMapper, DiseaseMapper diseaseMapper) {
        this.userFarmRepository = userFarmRepository;
        this.userFarmMapper = userFarmMapper;
        this.dataCollectionMapper = dataCollectionMapper;
        this.diseaseMapper = diseaseMapper;
        this.pestMapper = pestMapper;
    }

    public UserFarmDTO save(UserFarmDTO userFarmDTO) {
        this.log.debug("Request to save UserFarm : {}", (Object)userFarmDTO);
        if (userFarmDTO.getLatitude() != null && userFarmDTO.getLongitude() != null) {
            CompletableFuture addressFuture = this.geoUtility.getAddressFromGeoLocation(userFarmDTO.getLatitude().doubleValue(), userFarmDTO.getLongitude().doubleValue());
            this.log.debug("Current location addresss {}", (Object)addressFuture);
            this.log.debug("Current location latitude {} and longitude {}", (Object)userFarmDTO.getLatitude(), (Object)userFarmDTO.getLongitude());
            try {
                Optional state;
                Long countryId = null;
                Long stateId = null;
                Optional country = this.countryRepository.findByNameIgnoreCase(((GeoUtility.Address)addressFuture.get()).getCountry());
                if (country.isPresent()) {
                    countryId = ((Country)country.get()).getId();
                }
                if (countryId != null && (state = this.stateRepository.findByCountryIdAndNameIgnoreCaseOrCodeIgnoreCase(countryId, ((GeoUtility.Address)addressFuture.get()).getState(), ((GeoUtility.Address)addressFuture.get()).getState())).isPresent()) {
                    stateId = ((State)state.get()).getId();
                }
                this.log.debug("current location countryId {} and stateId {}", (Object)countryId, stateId);
                if (countryId == null || stateId == null) {
                    String message = this.i18nUtility.getMessage("userFarmService.save.user.farm.address.exception", null);
                    throw new BadRequestException(message);
                }
                userFarmDTO.setDistrict(((GeoUtility.Address)addressFuture.get()).getDistrict());
                userFarmDTO.setStateId(stateId);
                userFarmDTO.setCountryId(countryId);
                userFarmDTO.setPincode(((GeoUtility.Address)addressFuture.get()).getPostalCode());
            }
            catch (InterruptedException | NumberFormatException | ExecutionException e) {
                this.log.error(e.getMessage());
            }
        }
        UserFarm userFarm = this.userFarmMapper.toEntity(userFarmDTO);
        userFarm = (UserFarm)this.userFarmRepository.save((Object)userFarm);
        return this.userFarmMapper.toDto(userFarm);
    }

    @Transactional(readOnly=true)
    public Page<UserFarmDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all UserFarms");
        return this.userFarmRepository.findAll(pageable).map(arg_0 -> ((UserFarmMapper)this.userFarmMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<UserFarmDTO> findOne(Long id) {
        this.log.debug("Request to get UserFarm : {}", (Object)id);
        return this.userFarmRepository.findById((Object)id).map(arg_0 -> ((UserFarmMapper)this.userFarmMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional userFarm = this.userFarmRepository.findById((Object)id);
        if (userFarm.isPresent()) {
            ((UserFarm)userFarm.get()).setStatus(Boolean.valueOf(false));
            this.userFarmRepository.save((Object)((UserFarm)userFarm.get()));
        }
        this.log.debug("Request to delete UserFarm : {}", (Object)id);
        this.userFarmRepository.deleteById((Object)id);
    }

    public List<HistoryResponseDTO> getHistoryData(Long appUserId) {
        ArrayList<HistoryResponseDTO> historyResponseDTOs = new ArrayList<HistoryResponseDTO>();
        List userFarms = this.userFarmRepository.findAllByAppUserId(appUserId);
        List userFarmIds = userFarms.stream().map(UserFarm2 -> UserFarm2.getId()).collect(Collectors.toList());
        List dataCollections = this.dataCollectionRepository.findAllByUserFarmIdIn(userFarmIds);
        for (UserFarm userFarm : userFarms) {
            HistoryResponseDTO historyResponseDTO = new HistoryResponseDTO();
            historyResponseDTO.setUserFarmDTO(this.userFarmMapper.toDto(userFarm));
            List dataCollectionDTOs = this.dataCollectionMapper.toDto(dataCollections.stream().filter(DataCollection2 -> DataCollection2.getUserFarm().getId().equals(userFarm.getId())).collect(Collectors.toList()));
            Collections.sort(dataCollectionDTOs, new /* Unavailable Anonymous Inner Class!! */);
            historyResponseDTO.setDataCollectionDTOs(dataCollectionDTOs);
            historyResponseDTOs.add(historyResponseDTO);
        }
        return historyResponseDTOs;
    }

    public List<ObservationMapResponseDTO> getObservationMapData(Long userFarmId) {
        ArrayList<ObservationMapResponseDTO> observationMapResponseDTOs = new ArrayList<ObservationMapResponseDTO>();
        Optional userFarm = this.userFarmRepository.findByIdAndStatus(userFarmId, Boolean.valueOf(true));
        if (userFarm.isPresent()) {
            ObservationMapResponseDTO observationMapResponseDTO;
            List diseases = this.diseaseRepository.findAllByUserFarmId(userFarmId);
            List pests = this.pestRepository.findAllByUserFarmId(userFarmId);
            Optional dataCollection = this.dataCollectionRepository.findTopByUserFarmIdOrderByCreatedDateDesc(userFarmId);
            Optional productApplication = this.productApplicationRepository.findTopByUserFarmIdOrderByCreatedDateDesc(userFarmId);
            for (DiseaseDTO diseaseDTO : this.diseaseMapper.toDto(diseases)) {
                observationMapResponseDTO = new ObservationMapResponseDTO();
                observationMapResponseDTO.setDiseaseDTO(diseaseDTO);
                observationMapResponseDTO.setUserFarmDTO(this.userFarmMapper.toDto((UserFarm)userFarm.get()));
                if (dataCollection.isPresent()) {
                    observationMapResponseDTO.setEmergenceDate(((DataCollection)dataCollection.get()).getEmergenceDate());
                }
                if (productApplication.isPresent()) {
                    observationMapResponseDTO.setLastApplicationDate(((ProductApplication)productApplication.get()).getApplicationDate());
                }
                observationMapResponseDTOs.add(observationMapResponseDTO);
            }
            for (PestDTO pestDTO : this.pestMapper.toDto(pests)) {
                observationMapResponseDTO = new ObservationMapResponseDTO();
                observationMapResponseDTO.setPestDTO(pestDTO);
                observationMapResponseDTO.setUserFarmDTO(this.userFarmMapper.toDto((UserFarm)userFarm.get()));
                if (dataCollection.isPresent()) {
                    observationMapResponseDTO.setEmergenceDate(((DataCollection)dataCollection.get()).getEmergenceDate());
                }
                if (productApplication.isPresent()) {
                    observationMapResponseDTO.setLastApplicationDate(((ProductApplication)productApplication.get()).getApplicationDate());
                }
                observationMapResponseDTOs.add(observationMapResponseDTO);
            }
            return observationMapResponseDTOs;
        }
        String message = this.i18nUtility.getMessage(null, null);
        throw new BadRequestException(message);
    }
}

