/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.Topic;
import com.upl.fazorstarclub.repository.TopicRepository;
import com.upl.fazorstarclub.service.TopicImageService;
import com.upl.fazorstarclub.service.TopicService;
import com.upl.fazorstarclub.service.dto.TopicDTO;
import com.upl.fazorstarclub.service.dto.TopicImageDTO;
import com.upl.fazorstarclub.service.mapper.TopicMapper;
import com.upl.fazorstarclub.service.utility.AmazonUtility;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TopicServiceImpl
implements TopicService {
    private static final String TOPIC_IMAGE_UPLOAD_DIRECTORY = "topicImages";
    private final Logger log = LoggerFactory.getLogger(TopicServiceImpl.class);
    private final TopicRepository topicRepository;
    private final TopicMapper topicMapper;
    private final AmazonUtility amazonUtility;
    private final TopicImageService topicImageService;

    public TopicServiceImpl(TopicRepository topicRepository, TopicMapper topicMapper, AmazonUtility amazonUtility, TopicImageService topicImageService) {
        this.topicRepository = topicRepository;
        this.topicMapper = topicMapper;
        this.amazonUtility = amazonUtility;
        this.topicImageService = topicImageService;
    }

    public TopicDTO save(TopicDTO topicDTO) {
        this.log.debug("Request to save Topic : {}", (Object)topicDTO);
        Topic topic = this.topicMapper.toEntity(topicDTO);
        topic = (Topic)this.topicRepository.save((Object)topic);
        if (topicDTO.getTopicImages() != null) {
            for (TopicImageDTO topicImageDTO : topicDTO.getTopicImages()) {
                String[] splits = topicImageDTO.getImagePath().split("/");
                String fileName = splits[splits.length - 1];
                String destinationPath = "topicImages/" + topic.getId() + "/" + fileName;
                destinationPath = this.amazonUtility.moveFile(topicImageDTO.getImagePath(), destinationPath);
                topicImageDTO.setTopicId(topic.getId());
                topicImageDTO.setImagePath(destinationPath);
            }
            this.topicImageService.saveAllTopicImages(topicDTO.getTopicImages());
        }
        return this.topicMapper.toDto(topic);
    }

    @Transactional(readOnly=true)
    public Page<TopicDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Topics");
        return this.topicRepository.findAll(pageable).map(arg_0 -> ((TopicMapper)this.topicMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<TopicDTO> findOne(Long id) {
        this.log.debug("Request to get Topic : {}", (Object)id);
        return this.topicRepository.findById((Object)id).map(arg_0 -> ((TopicMapper)this.topicMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional topic = this.topicRepository.findById((Object)id);
        if (topic.isPresent()) {
            ((Topic)topic.get()).setStatus(Boolean.valueOf(false));
            this.topicRepository.save((Object)((Topic)topic.get()));
        }
        this.log.debug("Request to delete Topic : {}", (Object)id);
        this.topicRepository.deleteById((Object)id);
    }
}

