/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.TopicImage;
import com.upl.fazorstarclub.repository.TopicImageRepository;
import com.upl.fazorstarclub.service.TopicImageService;
import com.upl.fazorstarclub.service.dto.TopicImageDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.mapper.TopicImageMapper;
import com.upl.fazorstarclub.service.utility.AmazonUtility;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class TopicImageServiceImpl
implements TopicImageService {
    private static final String IMAGE_UPLOAD_DIRECTORY = "temp";
    private final Logger log = LoggerFactory.getLogger(TopicImageServiceImpl.class);
    private final TopicImageRepository topicImageRepository;
    private final TopicImageMapper topicImageMapper;
    @Value(value="${application.allowed-image-content-types:}")
    private String allowedImageContentTypes;
    @Value(value="${application.maximum-image-size:}")
    private String maximumImageSize;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private AmazonUtility amazonUtility;

    public TopicImageServiceImpl(TopicImageRepository topicImageRepository, TopicImageMapper topicImageMapper) {
        this.topicImageRepository = topicImageRepository;
        this.topicImageMapper = topicImageMapper;
    }

    public TopicImageDTO save(TopicImageDTO topicImageDTO) {
        this.log.debug("Request to save TopicImage : {}", (Object)topicImageDTO);
        TopicImage topicImage = this.topicImageMapper.toEntity(topicImageDTO);
        topicImage = (TopicImage)this.topicImageRepository.save((Object)topicImage);
        return this.topicImageMapper.toDto(topicImage);
    }

    @Transactional(readOnly=true)
    public List<TopicImageDTO> findAll() {
        this.log.debug("Request to get all TopicImages");
        return this.topicImageRepository.findAll().stream().map(arg_0 -> ((TopicImageMapper)this.topicImageMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<TopicImageDTO> findOne(Long id) {
        this.log.debug("Request to get TopicImage : {}", (Object)id);
        return this.topicImageRepository.findById((Object)id).map(arg_0 -> ((TopicImageMapper)this.topicImageMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete TopicImage : {}", (Object)id);
        this.topicImageRepository.deleteById((Object)id);
    }

    public List<TopicImageDTO> uploadImage(List<MultipartFile> files, Long appUserId) {
        String url = null;
        ArrayList<String> imageElements = new ArrayList<String>(Arrays.asList(this.allowedImageContentTypes.split(",")));
        ArrayList<TopicImageDTO> topicImageDTOs = new ArrayList<TopicImageDTO>();
        for (MultipartFile file : files) {
            String message;
            Double size = (double)file.getSize() / 1048576.0;
            if (imageElements.contains(file.getContentType())) {
                if (size <= Double.valueOf(this.maximumImageSize)) {
                    url = this.amazonUtility.uploadFile(file, "temp/" + appUserId);
                    TopicImageDTO topicImageDTO = new TopicImageDTO();
                    topicImageDTO.setImagePath(url);
                    topicImageDTO.setContentSize(String.valueOf(file.getSize()));
                    topicImageDTO.setContentType(file.getContentType());
                    topicImageDTO.setUploadedDate(Instant.now());
                    topicImageDTOs.add(topicImageDTO);
                    continue;
                }
                message = this.i18nUtility.getMessage("topicImageServiceImpl.upload.image.size.exception", null);
                throw new BadRequestException(message);
            }
            message = this.i18nUtility.getMessage("topicImageServiceImpl.upload.image.exception", null);
            throw new BadRequestException(message);
        }
        return topicImageDTOs;
    }

    public void saveAllTopicImages(List<TopicImageDTO> topicImageDTOs) {
        List topicImages = this.topicImageMapper.toEntity(topicImageDTOs);
        this.topicImageRepository.saveAll((Iterable)topicImages);
    }
}

