/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.SeedVariety;
import com.upl.fazorstarclub.repository.SeedVarietyRepository;
import com.upl.fazorstarclub.service.SeedVarietyService;
import com.upl.fazorstarclub.service.dto.SeedVarietyDTO;
import com.upl.fazorstarclub.service.mapper.SeedVarietyMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SeedVarietyServiceImpl
implements SeedVarietyService {
    private final Logger log = LoggerFactory.getLogger(SeedVarietyServiceImpl.class);
    private final SeedVarietyRepository seedVarietyRepository;
    private final SeedVarietyMapper seedVarietyMapper;

    public SeedVarietyServiceImpl(SeedVarietyRepository seedVarietyRepository, SeedVarietyMapper seedVarietyMapper) {
        this.seedVarietyRepository = seedVarietyRepository;
        this.seedVarietyMapper = seedVarietyMapper;
    }

    public SeedVarietyDTO save(SeedVarietyDTO seedVarietyDTO) {
        this.log.debug("Request to save SeedVariety : {}", (Object)seedVarietyDTO);
        SeedVariety seedVariety = (SeedVariety)this.seedVarietyMapper.toEntity((Object)seedVarietyDTO);
        seedVariety = (SeedVariety)this.seedVarietyRepository.save((Object)seedVariety);
        return (SeedVarietyDTO)this.seedVarietyMapper.toDto((Object)seedVariety);
    }

    @Transactional(readOnly=true)
    public List<SeedVarietyDTO> findAll() {
        this.log.debug("Request to get all SeedVarieties");
        return this.seedVarietyRepository.findAll().stream().map(arg_0 -> ((SeedVarietyMapper)this.seedVarietyMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<SeedVarietyDTO> findOne(Long id) {
        this.log.debug("Request to get SeedVariety : {}", (Object)id);
        return this.seedVarietyRepository.findById((Object)id).map(arg_0 -> ((SeedVarietyMapper)this.seedVarietyMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional seedVariety = this.seedVarietyRepository.findById((Object)id);
        if (seedVariety.isPresent()) {
            ((SeedVariety)seedVariety.get()).setStatus(Boolean.valueOf(false));
            this.seedVarietyRepository.save((Object)((SeedVariety)seedVariety.get()));
        }
        this.log.debug("Request to delete SeedVariety : {}", (Object)id);
        this.seedVarietyRepository.deleteById((Object)id);
    }
}

