/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.ProductApplication;
import com.upl.fazorstarclub.repository.ProductApplicationRepository;
import com.upl.fazorstarclub.service.ProductApplicationService;
import com.upl.fazorstarclub.service.dto.ProductApplicationDTO;
import com.upl.fazorstarclub.service.mapper.ProductApplicationMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProductApplicationServiceImpl
implements ProductApplicationService {
    private final Logger log = LoggerFactory.getLogger(ProductApplicationServiceImpl.class);
    private final ProductApplicationRepository productApplicationRepository;
    private final ProductApplicationMapper productApplicationMapper;

    public ProductApplicationServiceImpl(ProductApplicationRepository productApplicationRepository, ProductApplicationMapper productApplicationMapper) {
        this.productApplicationRepository = productApplicationRepository;
        this.productApplicationMapper = productApplicationMapper;
    }

    public ProductApplicationDTO save(ProductApplicationDTO productApplicationDTO) {
        this.log.debug("Request to save ProductApplication : {}", (Object)productApplicationDTO);
        ProductApplication productApplication = this.productApplicationMapper.toEntity(productApplicationDTO);
        productApplication = (ProductApplication)this.productApplicationRepository.save((Object)productApplication);
        return this.productApplicationMapper.toDto(productApplication);
    }

    @Transactional(readOnly=true)
    public Page<ProductApplicationDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all ProductApplications");
        return this.productApplicationRepository.findAll(pageable).map(arg_0 -> ((ProductApplicationMapper)this.productApplicationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<ProductApplicationDTO> findOne(Long id) {
        this.log.debug("Request to get ProductApplication : {}", (Object)id);
        return this.productApplicationRepository.findById((Object)id).map(arg_0 -> ((ProductApplicationMapper)this.productApplicationMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete ProductApplication : {}", (Object)id);
        this.productApplicationRepository.deleteById((Object)id);
    }
}

