/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.PreviousCrop;
import com.upl.fazorstarclub.repository.PreviousCropRepository;
import com.upl.fazorstarclub.service.PreviousCropService;
import com.upl.fazorstarclub.service.dto.PreviousCropDTO;
import com.upl.fazorstarclub.service.mapper.PreviousCropMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PreviousCropServiceImpl
implements PreviousCropService {
    private final Logger log = LoggerFactory.getLogger(PreviousCropServiceImpl.class);
    private final PreviousCropRepository previousCropRepository;
    private final PreviousCropMapper previousCropMapper;

    public PreviousCropServiceImpl(PreviousCropRepository previousCropRepository, PreviousCropMapper previousCropMapper) {
        this.previousCropRepository = previousCropRepository;
        this.previousCropMapper = previousCropMapper;
    }

    public PreviousCropDTO save(PreviousCropDTO previousCropDTO) {
        this.log.debug("Request to save PreviousCrop : {}", (Object)previousCropDTO);
        PreviousCrop previousCrop = (PreviousCrop)this.previousCropMapper.toEntity((Object)previousCropDTO);
        previousCrop = (PreviousCrop)this.previousCropRepository.save((Object)previousCrop);
        return (PreviousCropDTO)this.previousCropMapper.toDto((Object)previousCrop);
    }

    @Transactional(readOnly=true)
    public List<PreviousCropDTO> findAll() {
        this.log.debug("Request to get all PreviousCrops");
        return this.previousCropRepository.findAll().stream().map(arg_0 -> ((PreviousCropMapper)this.previousCropMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<PreviousCropDTO> findOne(Long id) {
        this.log.debug("Request to get PreviousCrop : {}", (Object)id);
        return this.previousCropRepository.findById((Object)id).map(arg_0 -> ((PreviousCropMapper)this.previousCropMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional previousCrop = this.previousCropRepository.findById((Object)id);
        if (previousCrop.isPresent()) {
            ((PreviousCrop)previousCrop.get()).setStatus(Boolean.valueOf(false));
            this.previousCropRepository.save((Object)((PreviousCrop)previousCrop.get()));
        }
        this.log.debug("Request to delete PreviousCrop : {}", (Object)id);
        this.previousCropRepository.deleteById((Object)id);
    }
}

