/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.Pest;
import com.upl.fazorstarclub.repository.PestRepository;
import com.upl.fazorstarclub.service.PestService;
import com.upl.fazorstarclub.service.dto.PestDTO;
import com.upl.fazorstarclub.service.mapper.PestMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PestServiceImpl
implements PestService {
    private final Logger log = LoggerFactory.getLogger(PestServiceImpl.class);
    private final PestRepository pestRepository;
    private final PestMapper pestMapper;

    public PestServiceImpl(PestRepository pestRepository, PestMapper pestMapper) {
        this.pestRepository = pestRepository;
        this.pestMapper = pestMapper;
    }

    public PestDTO save(PestDTO pestDTO) {
        this.log.debug("Request to save Pest : {}", (Object)pestDTO);
        Pest pest = this.pestMapper.toEntity(pestDTO);
        pest = (Pest)this.pestRepository.save((Object)pest);
        return this.pestMapper.toDto(pest);
    }

    @Transactional(readOnly=true)
    public Page<PestDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Pests");
        return this.pestRepository.findAll(pageable).map(arg_0 -> ((PestMapper)this.pestMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<PestDTO> findOne(Long id) {
        this.log.debug("Request to get Pest : {}", (Object)id);
        return this.pestRepository.findById((Object)id).map(arg_0 -> ((PestMapper)this.pestMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional pest = this.pestRepository.findById((Object)id);
        if (pest.isPresent()) {
            ((Pest)pest.get()).setStatus(Boolean.valueOf(false));
            this.pestRepository.save((Object)((Pest)pest.get()));
        }
        this.log.debug("Request to delete Pest : {}", (Object)id);
        this.pestRepository.deleteById((Object)id);
    }
}

