/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.PasswordHistory;
import com.upl.fazorstarclub.repository.PasswordHistoryRepository;
import com.upl.fazorstarclub.service.PasswordHistoryService;
import com.upl.fazorstarclub.service.dto.PasswordHistoryDTO;
import com.upl.fazorstarclub.service.mapper.PasswordHistoryMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PasswordHistoryServiceImpl
implements PasswordHistoryService {
    private final Logger log = LoggerFactory.getLogger(PasswordHistoryServiceImpl.class);
    private final PasswordHistoryRepository passwordHistoryRepository;
    private final PasswordHistoryMapper passwordHistoryMapper;

    public PasswordHistoryServiceImpl(PasswordHistoryRepository passwordHistoryRepository, PasswordHistoryMapper passwordHistoryMapper) {
        this.passwordHistoryRepository = passwordHistoryRepository;
        this.passwordHistoryMapper = passwordHistoryMapper;
    }

    public PasswordHistoryDTO save(PasswordHistoryDTO passwordHistoryDTO) {
        this.log.debug("Request to save PasswordHistory : {}", (Object)passwordHistoryDTO);
        PasswordHistory passwordHistory = this.passwordHistoryMapper.toEntity(passwordHistoryDTO);
        passwordHistory = (PasswordHistory)this.passwordHistoryRepository.save((Object)passwordHistory);
        return this.passwordHistoryMapper.toDto(passwordHistory);
    }

    @Transactional(readOnly=true)
    public List<PasswordHistoryDTO> findAll() {
        this.log.debug("Request to get all PasswordHistories");
        return this.passwordHistoryRepository.findAll().stream().map(arg_0 -> ((PasswordHistoryMapper)this.passwordHistoryMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<PasswordHistoryDTO> findOne(Long id) {
        this.log.debug("Request to get PasswordHistory : {}", (Object)id);
        return this.passwordHistoryRepository.findById((Object)id).map(arg_0 -> ((PasswordHistoryMapper)this.passwordHistoryMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete PasswordHistory : {}", (Object)id);
        this.passwordHistoryRepository.deleteById((Object)id);
    }
}

