/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.Notification;
import com.upl.fazorstarclub.repository.NotificationRepository;
import com.upl.fazorstarclub.service.NotificationService;
import com.upl.fazorstarclub.service.dto.NotificationDTO;
import com.upl.fazorstarclub.service.mapper.NotificationMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NotificationServiceImpl
implements NotificationService {
    private final Logger log = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private final NotificationRepository notificationRepository;
    private final NotificationMapper notificationMapper;

    public NotificationServiceImpl(NotificationRepository notificationRepository, NotificationMapper notificationMapper) {
        this.notificationRepository = notificationRepository;
        this.notificationMapper = notificationMapper;
    }

    public NotificationDTO save(NotificationDTO notificationDTO) {
        this.log.debug("Request to save Notification : {}", (Object)notificationDTO);
        Notification notification = (Notification)this.notificationMapper.toEntity((Object)notificationDTO);
        notification = (Notification)this.notificationRepository.save((Object)notification);
        return (NotificationDTO)this.notificationMapper.toDto((Object)notification);
    }

    @Transactional(readOnly=true)
    public Page<NotificationDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Notifications");
        return this.notificationRepository.findAll(pageable).map(arg_0 -> ((NotificationMapper)this.notificationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<NotificationDTO> findOne(Long id) {
        this.log.debug("Request to get Notification : {}", (Object)id);
        return this.notificationRepository.findById((Object)id).map(arg_0 -> ((NotificationMapper)this.notificationMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional notification = this.notificationRepository.findById((Object)id);
        if (notification.isPresent()) {
            ((Notification)notification.get()).setStatus(Boolean.valueOf(false));
            this.notificationRepository.save((Object)((Notification)notification.get()));
        }
        this.log.debug("Request to delete Notification : {}", (Object)id);
        this.notificationRepository.deleteById((Object)id);
    }
}

