/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.News;
import com.upl.fazorstarclub.repository.NewsRepository;
import com.upl.fazorstarclub.service.NewsService;
import com.upl.fazorstarclub.service.dto.NewsDTO;
import com.upl.fazorstarclub.service.mapper.NewsMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NewsServiceImpl
implements NewsService {
    private final Logger log = LoggerFactory.getLogger(NewsServiceImpl.class);
    private final NewsRepository newsRepository;
    private final NewsMapper newsMapper;

    public NewsServiceImpl(NewsRepository newsRepository, NewsMapper newsMapper) {
        this.newsRepository = newsRepository;
        this.newsMapper = newsMapper;
    }

    public NewsDTO save(NewsDTO newsDTO) {
        this.log.debug("Request to save News : {}", (Object)newsDTO);
        News news = (News)this.newsMapper.toEntity((Object)newsDTO);
        news = (News)this.newsRepository.save((Object)news);
        return (NewsDTO)this.newsMapper.toDto((Object)news);
    }

    @Transactional(readOnly=true)
    public Page<NewsDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all News");
        return this.newsRepository.findAll(pageable).map(arg_0 -> ((NewsMapper)this.newsMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<NewsDTO> findOne(Long id) {
        this.log.debug("Request to get News : {}", (Object)id);
        return this.newsRepository.findById((Object)id).map(arg_0 -> ((NewsMapper)this.newsMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional news = this.newsRepository.findById((Object)id);
        if (news.isPresent()) {
            ((News)news.get()).setStatus(Boolean.valueOf(false));
            this.newsRepository.save((Object)((News)news.get()));
        }
        this.log.debug("Request to delete News : {}", (Object)id);
        this.newsRepository.deleteById((Object)id);
    }
}

