/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.NewsImage;
import com.upl.fazorstarclub.repository.NewsImageRepository;
import com.upl.fazorstarclub.service.NewsImageService;
import com.upl.fazorstarclub.service.dto.NewsImageDTO;
import com.upl.fazorstarclub.service.mapper.NewsImageMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NewsImageServiceImpl
implements NewsImageService {
    private final Logger log = LoggerFactory.getLogger(NewsImageServiceImpl.class);
    private final NewsImageRepository newsImageRepository;
    private final NewsImageMapper newsImageMapper;

    public NewsImageServiceImpl(NewsImageRepository newsImageRepository, NewsImageMapper newsImageMapper) {
        this.newsImageRepository = newsImageRepository;
        this.newsImageMapper = newsImageMapper;
    }

    public NewsImageDTO save(NewsImageDTO newsImageDTO) {
        this.log.debug("Request to save NewsImage : {}", (Object)newsImageDTO);
        NewsImage newsImage = (NewsImage)this.newsImageMapper.toEntity((Object)newsImageDTO);
        newsImage = (NewsImage)this.newsImageRepository.save((Object)newsImage);
        return this.newsImageMapper.toDto(newsImage);
    }

    @Transactional(readOnly=true)
    public List<NewsImageDTO> findAll() {
        this.log.debug("Request to get all NewsImages");
        return this.newsImageRepository.findAll().stream().map(arg_0 -> ((NewsImageMapper)this.newsImageMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<NewsImageDTO> findOne(Long id) {
        this.log.debug("Request to get NewsImage : {}", (Object)id);
        return this.newsImageRepository.findById((Object)id).map(arg_0 -> ((NewsImageMapper)this.newsImageMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete NewsImage : {}", (Object)id);
        this.newsImageRepository.deleteById((Object)id);
    }
}

