/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.MasterPest;
import com.upl.fazorstarclub.repository.MasterPestRepository;
import com.upl.fazorstarclub.service.MasterPestService;
import com.upl.fazorstarclub.service.dto.MasterPestDTO;
import com.upl.fazorstarclub.service.mapper.MasterPestMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MasterPestServiceImpl
implements MasterPestService {
    private final Logger log = LoggerFactory.getLogger(MasterPestServiceImpl.class);
    private final MasterPestRepository masterPestRepository;
    private final MasterPestMapper masterPestMapper;

    public MasterPestServiceImpl(MasterPestRepository masterPestRepository, MasterPestMapper masterPestMapper) {
        this.masterPestRepository = masterPestRepository;
        this.masterPestMapper = masterPestMapper;
    }

    public MasterPestDTO save(MasterPestDTO masterPestDTO) {
        this.log.debug("Request to save MasterPest : {}", (Object)masterPestDTO);
        MasterPest masterPest = (MasterPest)this.masterPestMapper.toEntity((Object)masterPestDTO);
        masterPest = (MasterPest)this.masterPestRepository.save((Object)masterPest);
        return (MasterPestDTO)this.masterPestMapper.toDto((Object)masterPest);
    }

    @Transactional(readOnly=true)
    public List<MasterPestDTO> findAll() {
        this.log.debug("Request to get all MasterPests");
        return this.masterPestRepository.findAll().stream().map(arg_0 -> ((MasterPestMapper)this.masterPestMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<MasterPestDTO> findOne(Long id) {
        this.log.debug("Request to get MasterPest : {}", (Object)id);
        return this.masterPestRepository.findById((Object)id).map(arg_0 -> ((MasterPestMapper)this.masterPestMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional masterPest = this.masterPestRepository.findById((Object)id);
        if (masterPest.isPresent()) {
            ((MasterPest)masterPest.get()).setStatus(Boolean.valueOf(false));
            this.masterPestRepository.save((Object)((MasterPest)masterPest.get()));
        }
        this.log.debug("Request to delete MasterPest : {}", (Object)id);
        this.masterPestRepository.deleteById((Object)id);
    }
}

