/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.MasterDisease;
import com.upl.fazorstarclub.repository.MasterDiseaseRepository;
import com.upl.fazorstarclub.service.MasterDiseaseService;
import com.upl.fazorstarclub.service.dto.MasterDiseaseDTO;
import com.upl.fazorstarclub.service.mapper.MasterDiseaseMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MasterDiseaseServiceImpl
implements MasterDiseaseService {
    private final Logger log = LoggerFactory.getLogger(MasterDiseaseServiceImpl.class);
    private final MasterDiseaseRepository masterDiseaseRepository;
    private final MasterDiseaseMapper masterDiseaseMapper;

    public MasterDiseaseServiceImpl(MasterDiseaseRepository masterDiseaseRepository, MasterDiseaseMapper masterDiseaseMapper) {
        this.masterDiseaseRepository = masterDiseaseRepository;
        this.masterDiseaseMapper = masterDiseaseMapper;
    }

    public MasterDiseaseDTO save(MasterDiseaseDTO masterDiseaseDTO) {
        this.log.debug("Request to save MasterDisease : {}", (Object)masterDiseaseDTO);
        MasterDisease masterDisease = (MasterDisease)this.masterDiseaseMapper.toEntity((Object)masterDiseaseDTO);
        masterDisease = (MasterDisease)this.masterDiseaseRepository.save((Object)masterDisease);
        return (MasterDiseaseDTO)this.masterDiseaseMapper.toDto((Object)masterDisease);
    }

    @Transactional(readOnly=true)
    public List<MasterDiseaseDTO> findAll() {
        this.log.debug("Request to get all MasterDiseases");
        return this.masterDiseaseRepository.findAll().stream().map(arg_0 -> ((MasterDiseaseMapper)this.masterDiseaseMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<MasterDiseaseDTO> findOne(Long id) {
        this.log.debug("Request to get MasterDisease : {}", (Object)id);
        return this.masterDiseaseRepository.findById((Object)id).map(arg_0 -> ((MasterDiseaseMapper)this.masterDiseaseMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional masterDisease = this.masterDiseaseRepository.findById((Object)id);
        if (masterDisease.isPresent()) {
            ((MasterDisease)masterDisease.get()).setStatus(Boolean.valueOf(false));
            this.masterDiseaseRepository.save((Object)((MasterDisease)masterDisease.get()));
        }
        this.log.debug("Request to delete MasterDisease : {}", (Object)id);
        this.masterDiseaseRepository.deleteById((Object)id);
    }
}

