/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.Irrigation;
import com.upl.fazorstarclub.repository.IrrigationRepository;
import com.upl.fazorstarclub.service.IrrigationService;
import com.upl.fazorstarclub.service.dto.IrrigationDTO;
import com.upl.fazorstarclub.service.mapper.IrrigationMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IrrigationServiceImpl
implements IrrigationService {
    private final Logger log = LoggerFactory.getLogger(IrrigationServiceImpl.class);
    private final IrrigationRepository irrigationRepository;
    private final IrrigationMapper irrigationMapper;

    public IrrigationServiceImpl(IrrigationRepository irrigationRepository, IrrigationMapper irrigationMapper) {
        this.irrigationRepository = irrigationRepository;
        this.irrigationMapper = irrigationMapper;
    }

    public IrrigationDTO save(IrrigationDTO irrigationDTO) {
        this.log.debug("Request to save Irrigation : {}", (Object)irrigationDTO);
        Irrigation irrigation = (Irrigation)this.irrigationMapper.toEntity((Object)irrigationDTO);
        irrigation = (Irrigation)this.irrigationRepository.save((Object)irrigation);
        return this.irrigationMapper.toDto(irrigation);
    }

    @Transactional(readOnly=true)
    public List<IrrigationDTO> findAll() {
        this.log.debug("Request to get all Irrigations");
        return this.irrigationRepository.findAll().stream().map(arg_0 -> ((IrrigationMapper)this.irrigationMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<IrrigationDTO> findOne(Long id) {
        this.log.debug("Request to get Irrigation : {}", (Object)id);
        return this.irrigationRepository.findById((Object)id).map(arg_0 -> ((IrrigationMapper)this.irrigationMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional irrigation = this.irrigationRepository.findById((Object)id);
        if (irrigation.isPresent()) {
            ((Irrigation)irrigation.get()).setStatus(Boolean.valueOf(false));
            this.irrigationRepository.save((Object)((Irrigation)irrigation.get()));
        }
        this.log.debug("Request to delete Irrigation : {}", (Object)id);
        this.irrigationRepository.deleteById((Object)id);
    }
}

