/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.Disease;
import com.upl.fazorstarclub.repository.DiseaseRepository;
import com.upl.fazorstarclub.service.DiseaseService;
import com.upl.fazorstarclub.service.dto.DiseaseDTO;
import com.upl.fazorstarclub.service.mapper.DiseaseMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DiseaseServiceImpl
implements DiseaseService {
    private final Logger log = LoggerFactory.getLogger(DiseaseServiceImpl.class);
    private final DiseaseRepository diseaseRepository;
    private final DiseaseMapper diseaseMapper;

    public DiseaseServiceImpl(DiseaseRepository diseaseRepository, DiseaseMapper diseaseMapper) {
        this.diseaseRepository = diseaseRepository;
        this.diseaseMapper = diseaseMapper;
    }

    public DiseaseDTO save(DiseaseDTO diseaseDTO) {
        this.log.debug("Request to save Disease : {}", (Object)diseaseDTO);
        Disease disease = this.diseaseMapper.toEntity(diseaseDTO);
        disease = (Disease)this.diseaseRepository.save((Object)disease);
        return this.diseaseMapper.toDto(disease);
    }

    @Transactional(readOnly=true)
    public Page<DiseaseDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Diseases");
        return this.diseaseRepository.findAll(pageable).map(arg_0 -> ((DiseaseMapper)this.diseaseMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<DiseaseDTO> findOne(Long id) {
        this.log.debug("Request to get Disease : {}", (Object)id);
        return this.diseaseRepository.findById((Object)id).map(arg_0 -> ((DiseaseMapper)this.diseaseMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional disease = this.diseaseRepository.findById((Object)id);
        if (disease.isPresent()) {
            ((Disease)disease.get()).setStatus(Boolean.valueOf(false));
            this.diseaseRepository.save((Object)((Disease)disease.get()));
        }
        this.log.debug("Request to delete Disease : {}", (Object)id);
        this.diseaseRepository.deleteById((Object)id);
    }
}

