/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.Debate;
import com.upl.fazorstarclub.domain.DebateTopicLike;
import com.upl.fazorstarclub.domain.Topic;
import com.upl.fazorstarclub.repository.AppUserRepository;
import com.upl.fazorstarclub.repository.DebateRepository;
import com.upl.fazorstarclub.repository.DebateTopicLikeRepository;
import com.upl.fazorstarclub.repository.TopicRepository;
import com.upl.fazorstarclub.service.DebateService;
import com.upl.fazorstarclub.service.dto.DebateDTO;
import com.upl.fazorstarclub.service.dto.DebateTopicLikeDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.mapper.DebateMapper;
import com.upl.fazorstarclub.service.mapper.DebateTopicLikeMapper;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DebateServiceImpl
implements DebateService {
    private final Logger log = LoggerFactory.getLogger(DebateServiceImpl.class);
    @Autowired
    private I18nUtility i18nUtility;
    private final DebateRepository debateRepository;
    private final DebateMapper debateMapper;
    private final TopicRepository topicRepository;
    private final DebateTopicLikeRepository debateTopicLikeRepository;
    private final AppUserRepository appUserRepository;
    private final DebateTopicLikeMapper debateTopicLikeMapper;

    public DebateServiceImpl(DebateRepository debateRepository, DebateMapper debateMapper, TopicRepository topicRepository, DebateTopicLikeRepository debateTopicLikeRepository, AppUserRepository appUserRepository, DebateTopicLikeMapper debateTopicLikeMapper) {
        this.debateRepository = debateRepository;
        this.debateMapper = debateMapper;
        this.topicRepository = topicRepository;
        this.debateTopicLikeRepository = debateTopicLikeRepository;
        this.appUserRepository = appUserRepository;
        this.debateTopicLikeMapper = debateTopicLikeMapper;
    }

    public DebateDTO save(DebateDTO debateDTO) {
        this.log.debug("Request to save Debate : {}", (Object)debateDTO);
        Debate debate = (Debate)this.debateMapper.toEntity((Object)debateDTO);
        if (debateDTO.getId() != null && this.debateRepository.findById((Object)debateDTO.getId()).isEmpty()) {
            String message = this.i18nUtility.getMessage("debate.update.notfount.exception", null);
            throw new BadRequestException(message);
        }
        debate = (Debate)this.debateRepository.save((Object)debate);
        return (DebateDTO)this.debateMapper.toDto((Object)debate);
    }

    @Transactional(readOnly=true)
    public Page<DebateDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Debates");
        return this.debateRepository.findAll(pageable).map(arg_0 -> ((DebateMapper)this.debateMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<DebateDTO> findOne(Long id) {
        this.log.debug("Request to get Debate : {}", (Object)id);
        return this.debateRepository.findById((Object)id).map(arg_0 -> ((DebateMapper)this.debateMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Debate : {}", (Object)id);
        this.debateRepository.deleteById((Object)id);
    }

    public void saveUserLikeForTopic(Long topicId, Long loggedInUserId) {
        this.log.debug("Request to save user like with topicId: {} and userId: {}", (Object)topicId, (Object)loggedInUserId);
        Optional topic = this.topicRepository.findById((Object)topicId);
        if (topic.isPresent()) {
            DebateTopicLike debateTopicLike = new DebateTopicLike();
            debateTopicLike.setTopic((Topic)topic.get());
            debateTopicLike.setAppUser((AppUser)this.appUserRepository.findById((Object)loggedInUserId).get());
            debateTopicLike.setStatus(Boolean.valueOf(true));
            this.debateTopicLikeRepository.save((Object)debateTopicLike);
        }
    }

    public List<DebateTopicLikeDTO> getAllUserLikedTopics(Long loggedInUserId) {
        this.log.debug("Request to get user like");
        List debateTopicLikeDTOs = this.debateTopicLikeRepository.findAllByAppUserId(loggedInUserId);
        return this.debateTopicLikeMapper.toDto(debateTopicLikeDTOs);
    }
}

