/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.DebateComment;
import com.upl.fazorstarclub.repository.DebateCommentRepository;
import com.upl.fazorstarclub.service.DebateCommentService;
import com.upl.fazorstarclub.service.dto.DebateCommentDTO;
import com.upl.fazorstarclub.service.mapper.DebateCommentMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DebateCommentServiceImpl
implements DebateCommentService {
    private final Logger log = LoggerFactory.getLogger(DebateCommentServiceImpl.class);
    private final DebateCommentRepository debateCommentRepository;
    private final DebateCommentMapper debateCommentMapper;

    public DebateCommentServiceImpl(DebateCommentRepository debateCommentRepository, DebateCommentMapper debateCommentMapper) {
        this.debateCommentRepository = debateCommentRepository;
        this.debateCommentMapper = debateCommentMapper;
    }

    public DebateCommentDTO save(DebateCommentDTO debateCommentDTO) {
        this.log.debug("Request to save DebateComment : {}", (Object)debateCommentDTO);
        DebateComment debateComment = this.debateCommentMapper.toEntity(debateCommentDTO);
        debateComment = (DebateComment)this.debateCommentRepository.save((Object)debateComment);
        return this.debateCommentMapper.toDto(debateComment);
    }

    @Transactional(readOnly=true)
    public Page<DebateCommentDTO> findAllByTopicId(Pageable pageable, Long topicId) {
        this.log.debug("Request to get all DebateComments");
        return this.debateCommentRepository.findAllByTopicIdAndStatusTrueOrderByCreatedDateDesc(pageable, topicId).map(arg_0 -> ((DebateCommentMapper)this.debateCommentMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<DebateCommentDTO> findOne(Long id) {
        this.log.debug("Request to get DebateComment : {}", (Object)id);
        return this.debateCommentRepository.findByIdAndStatusIsTrue(id).map(arg_0 -> ((DebateCommentMapper)this.debateCommentMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete DebateComment : {}", (Object)id);
        Optional optionalDebateComment = this.debateCommentRepository.findById((Object)id);
        if (optionalDebateComment.isPresent()) {
            DebateComment debateComment = (DebateComment)optionalDebateComment.get();
            debateComment.setStatus(Boolean.valueOf(false));
            this.debateCommentRepository.save((Object)debateComment);
        }
    }

    public Long getUserResponses(Long topicId) {
        this.log.debug("Request to get user responses for topicId: {}", (Object)topicId);
        Long response = this.debateCommentRepository.findCountByTopicId(topicId);
        return response;
    }
}

