/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.DataCollection;
import com.upl.fazorstarclub.domain.Disease;
import com.upl.fazorstarclub.domain.Notification;
import com.upl.fazorstarclub.domain.Pest;
import com.upl.fazorstarclub.domain.ProductApplication;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.domain.enumeration.Category;
import com.upl.fazorstarclub.domain.enumeration.MarketType;
import com.upl.fazorstarclub.domain.enumeration.NotificationName;
import com.upl.fazorstarclub.domain.enumeration.Role;
import com.upl.fazorstarclub.repository.AppUserRepository;
import com.upl.fazorstarclub.repository.DataCollectionRepository;
import com.upl.fazorstarclub.repository.DiseaseRepository;
import com.upl.fazorstarclub.repository.NotificationRepository;
import com.upl.fazorstarclub.repository.PestRepository;
import com.upl.fazorstarclub.repository.ProductApplicationRepository;
import com.upl.fazorstarclub.repository.StateRepository;
import com.upl.fazorstarclub.repository.UserFarmRepository;
import com.upl.fazorstarclub.service.DataCollectionService;
import com.upl.fazorstarclub.service.UserFarmService;
import com.upl.fazorstarclub.service.dto.DSSResponseDTO;
import com.upl.fazorstarclub.service.dto.DataCollectionDTO;
import com.upl.fazorstarclub.service.dto.UserFarmDTO;
import com.upl.fazorstarclub.service.dto.UserMapResponseDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.mapper.DataCollectionMapper;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataCollectionServiceImpl
implements DataCollectionService {
    private final Logger log = LoggerFactory.getLogger(DataCollectionServiceImpl.class);
    private final DataCollectionRepository dataCollectionRepository;
    private final DataCollectionMapper dataCollectionMapper;
    private final UserFarmService userFarmService;
    private final StateRepository stateRepository;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private AppUserRepository appUserRepository;
    @Autowired
    private UserFarmRepository userFarmRepository;
    @Autowired
    private PestRepository pestRepository;
    @Autowired
    private DiseaseRepository diseaseRepository;
    @Autowired
    private ProductApplicationRepository productApplicationRepository;
    @Autowired
    private NotificationRepository notificationRepository;

    public DataCollectionServiceImpl(DataCollectionRepository dataCollectionRepository, DataCollectionMapper dataCollectionMapper, UserFarmService userFarmService, StateRepository stateRepository) {
        this.dataCollectionRepository = dataCollectionRepository;
        this.dataCollectionMapper = dataCollectionMapper;
        this.userFarmService = userFarmService;
        this.stateRepository = stateRepository;
    }

    public DataCollectionDTO save(DataCollectionDTO dataCollectionDTO) {
        this.log.debug("Request to save DataCollection : {}", (Object)dataCollectionDTO);
        DataCollection dataCollection = this.dataCollectionMapper.toEntity(dataCollectionDTO);
        Optional userFarm = this.userFarmService.findOne(dataCollectionDTO.getUserFarmId());
        if (userFarm.isPresent()) {
            switch (((UserFarmDTO)userFarm.get()).getMarketType()) {
                case "Fresh": {
                    Double fresh = dataCollection.getTuberPlant25mmCount().doubleValue() / dataCollection.getTotalNumberOfTuberPlant().doubleValue() * 100.0;
                    dataCollection.setTuberPlant25mmPercentage(fresh);
                    break;
                }
                case "Processed": {
                    Double processed = dataCollection.getTuberPlant35mmCount().doubleValue() / dataCollection.getTotalNumberOfTuberPlant().doubleValue() * 100.0;
                    dataCollection.setTuberPlant35mmPercentage(processed);
                }
            }
        } else {
            String message = this.i18nUtility.getMessage("userfarm.not.found.exception", null);
            throw new BadRequestException(message);
        }
        dataCollection = (DataCollection)this.dataCollectionRepository.save((Object)dataCollection);
        return this.dataCollectionMapper.toDto(dataCollection);
    }

    @Transactional(readOnly=true)
    public Page<DataCollectionDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all DataCollections");
        return this.dataCollectionRepository.findAll(pageable).map(arg_0 -> ((DataCollectionMapper)this.dataCollectionMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<DataCollectionDTO> findOne(Long id) {
        this.log.debug("Request to get DataCollection : {}", (Object)id);
        return this.dataCollectionRepository.findById((Object)id).map(arg_0 -> ((DataCollectionMapper)this.dataCollectionMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        Optional dataCollection = this.dataCollectionRepository.findById((Object)id);
        if (dataCollection.isPresent()) {
            ((DataCollection)dataCollection.get()).setStatus(Boolean.valueOf(false));
            this.dataCollectionRepository.save((Object)((DataCollection)dataCollection.get()));
        }
        this.log.debug("Request to delete DataCollection : {}", (Object)id);
        this.dataCollectionRepository.deleteById((Object)id);
    }

    public List<UserMapResponseDTO> getAllUserList(Role role) {
        List appUsers = this.appUserRepository.findAllByRole(role);
        List appUserIds = this.appUserRepository.findAllByRole(role).stream().map(AppUser2 -> AppUser2.getId()).collect(Collectors.toList());
        List userFarms = this.userFarmRepository.findAllByAppUserIds(appUserIds);
        List userFarmIds = userFarms.stream().map(UserFarm2 -> UserFarm2.getId()).collect(Collectors.toList());
        List dataCollections = this.dataCollectionRepository.findAllTopDataCollectionRecords(userFarmIds);
        List pests = this.pestRepository.findAllTopPestRecords(userFarmIds);
        List diseases = this.diseaseRepository.findAllTopDiseaseRecords(userFarmIds);
        List productApplications = this.productApplicationRepository.findAllTopProductApplicationRecords(userFarmIds);
        ArrayList<UserMapResponseDTO> userMapResponseDTOs = new ArrayList<UserMapResponseDTO>();
        if (!appUsers.isEmpty()) {
            for (AppUser appUser : appUsers) {
                UserMapResponseDTO userMapResponseDTO = new UserMapResponseDTO();
                userMapResponseDTO.setFullName(appUser.getUserName());
                userMapResponseDTO.setMobileNumber(appUser.getMobileNumber());
                userMapResponseDTO.setPincode(appUser.getPincode());
                userMapResponseDTO.setCity(appUser.getCity());
                userMapResponseDTO.setStreet(appUser.getStreet());
                userMapResponseDTO.setLatitude(appUser.getLatitude());
                userMapResponseDTO.setLongitude(appUser.getLongitude());
                List appUserFarm = userFarms.stream().filter(UserFarm2 -> UserFarm2.getAppUser().getId().equals(appUser.getId())).collect(Collectors.toList());
                if (!appUserFarm.isEmpty()) {
                    List filteredProductApplication;
                    List filteredDisease;
                    userMapResponseDTO.setSeedVariety(((UserFarm)appUserFarm.get(0)).getSeedVariety().getName());
                    userMapResponseDTO.setMarketType(((UserFarm)appUserFarm.get(0)).getMarketType().getValue());
                    userMapResponseDTO.setCountryId(((UserFarm)appUserFarm.get(0)).getCountry().getId());
                    userMapResponseDTO.setStateId(((UserFarm)appUserFarm.get(0)).getState().getId());
                    userMapResponseDTO.setDistrict(((UserFarm)appUserFarm.get(0)).getDistrict());
                    userMapResponseDTO.setCountryName(((UserFarm)appUserFarm.get(0)).getCountry().getName());
                    userMapResponseDTO.setStateName(((UserFarm)appUserFarm.get(0)).getState().getName());
                    userMapResponseDTO.setLatitude(((UserFarm)appUserFarm.get(0)).getLatitude());
                    userMapResponseDTO.setLongitude(((UserFarm)appUserFarm.get(0)).getLongitude());
                    userMapResponseDTO.setStatus(((UserFarm)appUserFarm.get(0)).getStatus());
                    List dataCollection = dataCollections.stream().filter(DataCollection2 -> DataCollection2.getUserFarm().getAppUser().equals((Object)appUser.getId())).collect(Collectors.toList());
                    if (!dataCollection.isEmpty()) {
                        userMapResponseDTO.setEmergenceDate(((DataCollection)dataCollection.get(0)).getEmergenceDate());
                        userMapResponseDTO.setPotatoSize(MarketType.FRESH.equals((Object)((UserFarm)appUserFarm.get(0)).getMarketType()) ? ((DataCollection)dataCollection.get(0)).getTuberPlant25mmPercentage() : ((DataCollection)dataCollection.get(0)).getTuberPlant35mmPercentage());
                    }
                    SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                    List filteredPest = pests.stream().filter(Pest2 -> Pest2.getUserFarm().getId().equals(appUser.getId())).collect(Collectors.toList());
                    if (!filteredPest.isEmpty()) {
                        Date date = Date.from(((Pest)filteredPest.get(0)).getCreatedDate());
                        userMapResponseDTO.setDeclaredPest(((Pest)filteredPest.get(0)).getName() + "-" + formatter.format(date));
                    }
                    if (!(filteredDisease = diseases.stream().filter(Disease2 -> Disease2.getUserFarm().getId().equals(appUser.getId())).collect(Collectors.toList())).isEmpty()) {
                        Date date = Date.from(((Disease)filteredDisease.get(0)).getCreatedDate());
                        userMapResponseDTO.setDeclaredDisease(((Disease)filteredDisease.get(0)).getName() + "-" + formatter.format(date));
                    }
                    if (!(filteredProductApplication = productApplications.stream().filter(ProductApplication2 -> ProductApplication2.getUserFarm().getId().equals(appUser.getId())).collect(Collectors.toList())).isEmpty()) {
                        userMapResponseDTO.setLastApplicationDate(((ProductApplication)filteredProductApplication.get(0)).getApplicationDate());
                    }
                }
                userMapResponseDTOs.add(userMapResponseDTO);
            }
        }
        return userMapResponseDTOs;
    }

    public List<DSSResponseDTO> getAllDSSPotatoEmergenceData(Long countryId) {
        ArrayList<DSSResponseDTO> dssResponseDTOs = new ArrayList<DSSResponseDTO>();
        List dataCollections = this.dataCollectionRepository.findAllByRegion();
        List states = this.stateRepository.findAllByCountryId(countryId);
        for (State state : states) {
            List regionsRecords = dataCollections.stream().filter(DataCollection2 -> state.getName().equals(DataCollection2.getUserFarm().getState().getName())).collect(Collectors.toList());
            DSSResponseDTO dssResponseDTO = new DSSResponseDTO();
            JSONArray JSONarray = new JSONArray(state.getCoordinates());
            dssResponseDTO.setRegionName(state.getName());
            dssResponseDTO.setCoordinates(JSONarray);
            if (regionsRecords.isEmpty()) {
                dssResponseDTO.setIsEmergenceAvailable(Boolean.valueOf(false));
            } else {
                dssResponseDTO.setIsEmergenceAvailable(Boolean.valueOf(true));
            }
            dssResponseDTOs.add(dssResponseDTO);
        }
        return dssResponseDTOs;
    }

    public List<DSSResponseDTO> getAllDSSConditionalData(Long countryId) {
        ArrayList<DSSResponseDTO> dssResponseDTOs = new ArrayList<DSSResponseDTO>();
        List dataCollections = this.dataCollectionRepository.findAllByRegion();
        List states = this.stateRepository.findAllByCountryId(countryId);
        for (State state : states) {
            Double percentage = 0.0;
            List regionsRecords = dataCollections.stream().filter(DataCollection2 -> state.getName().equals(DataCollection2.getUserFarm().getState().getName())).collect(Collectors.toList());
            for (DataCollection dataCollection : regionsRecords) {
                percentage = percentage + (dataCollection.getTuberPlant25mmPercentage() != null ? dataCollection.getTuberPlant25mmPercentage() : dataCollection.getTuberPlant35mmPercentage());
            }
            DSSResponseDTO dssResponseDTO = new DSSResponseDTO();
            JSONArray JSONarray = new JSONArray(state.getCoordinates());
            dssResponseDTO.setRegionName(state.getName());
            dssResponseDTO.setCoordinates(JSONarray);
            dssResponseDTO.setEmergencePercentage(percentage);
            dssResponseDTOs.add(dssResponseDTO);
        }
        return dssResponseDTOs;
    }

    @Scheduled(cron="0 30 9 * * 1")
    public void addDataCollectionNotification() {
        List appUsers = this.appUserRepository.findAll();
        List userFarms = this.userFarmRepository.findAllByAppUserIdIn(appUsers.stream().map(AppUser2 -> AppUser2.getId()).collect(Collectors.toList()));
        for (UserFarm userFarm : userFarms) {
            Optional dataCollection = this.dataCollectionRepository.findTopByUserFarmIdOrderByCreatedDateDesc(userFarm.getId());
            if (!dataCollection.isPresent()) continue;
            Notification notification = new Notification();
            notification.setAppUser(userFarm.getAppUser());
            notification.setCategory(Category.NOTIFY);
            Long percent = Math.round(MarketType.FRESH.equals((Object)userFarm.getMarketType()) ? ((DataCollection)dataCollection.get()).getTuberPlant25mmPercentage() : (MarketType.PROCESSED.equals((Object)userFarm.getMarketType()) ? ((DataCollection)dataCollection.get()).getTuberPlant35mmPercentage() : 0.0));
            String size = MarketType.FRESH.equals((Object)userFarm.getMarketType()) ? "25" : (MarketType.PROCESSED.equals((Object)userFarm.getMarketType()) ? "35" : "0");
            notification.setDescription(this.i18nUtility.getMessage("datacollection.notification.weekly.update", new Object[]{percent, size}));
            notification.setExpires(Instant.now().plus(7L, ChronoUnit.DAYS));
            notification.setNotificationName(NotificationName.DATA_COLLECTION);
            notification.setStatus(Boolean.valueOf(true));
            this.notificationRepository.save((Object)notification);
        }
    }
}

