/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.repository.CountryRepository;
import com.upl.fazorstarclub.service.CountryService;
import com.upl.fazorstarclub.service.dto.CountryDTO;
import com.upl.fazorstarclub.service.mapper.CountryMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CountryServiceImpl
implements CountryService {
    private final Logger log = LoggerFactory.getLogger(CountryServiceImpl.class);
    private final CountryRepository countryRepository;
    private final CountryMapper countryMapper;

    public CountryServiceImpl(CountryRepository countryRepository, CountryMapper countryMapper) {
        this.countryRepository = countryRepository;
        this.countryMapper = countryMapper;
    }

    public CountryDTO save(CountryDTO countryDTO) {
        this.log.debug("Request to save Country : {}", (Object)countryDTO);
        Country country = (Country)this.countryMapper.toEntity((Object)countryDTO);
        country = (Country)this.countryRepository.save((Object)country);
        return (CountryDTO)this.countryMapper.toDto((Object)country);
    }

    @Transactional(readOnly=true)
    public List<CountryDTO> findAll() {
        this.log.debug("Request to get all Countries");
        return this.countryRepository.findAll().stream().map(arg_0 -> ((CountryMapper)this.countryMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<CountryDTO> findOne(Long id) {
        this.log.debug("Request to get Country : {}", (Object)id);
        return this.countryRepository.findById((Object)id).map(arg_0 -> ((CountryMapper)this.countryMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Country : {}", (Object)id);
        Optional country = this.countryRepository.findById((Object)id);
        if (country.isPresent()) {
            ((Country)country.get()).setStatus(Boolean.valueOf(false));
            this.countryRepository.save((Object)((Country)country.get()));
        }
    }
}

