/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.AppUserLogin;
import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.Notification;
import com.upl.fazorstarclub.domain.PasswordHistory;
import com.upl.fazorstarclub.domain.PasswordResetEmailLog;
import com.upl.fazorstarclub.domain.PasswordResetToken;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.domain.enumeration.Category;
import com.upl.fazorstarclub.domain.enumeration.NotificationName;
import com.upl.fazorstarclub.domain.enumeration.Role;
import com.upl.fazorstarclub.repository.AppUserLoginRepository;
import com.upl.fazorstarclub.repository.AppUserRepository;
import com.upl.fazorstarclub.repository.CountryRepository;
import com.upl.fazorstarclub.repository.NotificationRepository;
import com.upl.fazorstarclub.repository.PasswordHistoryRepository;
import com.upl.fazorstarclub.repository.PasswordResetEmailLogRepository;
import com.upl.fazorstarclub.repository.PasswordResetTokenRepository;
import com.upl.fazorstarclub.repository.StateRepository;
import com.upl.fazorstarclub.security.SecurityUtils;
import com.upl.fazorstarclub.security.jwt.TokenProvider;
import com.upl.fazorstarclub.security.okta.AuthInfo;
import com.upl.fazorstarclub.security.okta.MobileAuthInfo;
import com.upl.fazorstarclub.security.okta.OktaSecurity;
import com.upl.fazorstarclub.security.okta.OktaUser;
import com.upl.fazorstarclub.service.AppUserDeviceService;
import com.upl.fazorstarclub.service.AppUserService;
import com.upl.fazorstarclub.service.AuthenticationService;
import com.upl.fazorstarclub.service.dto.AppUserDTO;
import com.upl.fazorstarclub.service.dto.AppUserDeviceDTO;
import com.upl.fazorstarclub.service.dto.AuthenticationDTO;
import com.upl.fazorstarclub.service.dto.JWTTokenDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.mapper.AppUserMapper;
import com.upl.fazorstarclub.service.utility.GeoUtility;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import com.upl.fazorstarclub.service.utility.MailUtility;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;

@Service
@Transactional
public class AuthenticationServiceImpl
implements AuthenticationService {
    private final Logger log = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    private final AppUserRepository appUserRepository;
    private final AppUserLoginRepository appUserLoginRepository;
    @Autowired
    private TokenProvider tokenProvider;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private OktaSecurity oktaSecurity;
    @Autowired
    private AppUserService appUserService;
    @Autowired
    private AppUserMapper appUserMapper;
    @Autowired
    private AppUserDeviceService appUserDeviceService;
    @Autowired
    private CountryRepository countryRepository;
    @Autowired
    private StateRepository stateRepository;
    private final GeoUtility geoUtility;
    @Autowired
    private PasswordHistoryRepository passwordHistoryRepository;
    @Autowired
    private PasswordResetEmailLogRepository passwordResetEmailLogRepository;
    @Autowired
    private PasswordResetTokenRepository passwordResetTokenRepository;
    @Autowired
    private MailUtility mailUtility;
    @Value(value="${application.password-reset-endpoint:}")
    private String passwordResetEndpoint;
    @Value(value="${application.default-language:}")
    private String defaultLanguage;
    @Autowired
    private NotificationRepository notificationRepository;
    private static final Long PASSWORD_CHANGE = 60L;
    private static final Long PASSWORD_WARNING = 50L;
    private static final Long PASSWORD_RESET_EMAIL_LIMIT = 5L;
    private static final Long PASSWORD_RESET_DURATION = 1L;
    private static final String DATE_FORMAT = "EEEE dd MMMM HH:mm:ss z yyyy";

    @Autowired
    public AuthenticationServiceImpl(AppUserRepository appUserRepository, AppUserLoginRepository appUserLoginRepository, GeoUtility geoUtility) {
        this.appUserRepository = appUserRepository;
        this.appUserLoginRepository = appUserLoginRepository;
        this.geoUtility = geoUtility;
    }

    public Boolean logout(String token) {
        Optional appUserLogin = this.appUserLoginRepository.findByToken(token);
        if (appUserLogin.isPresent()) {
            AppUserLogin updateAppUserLogin = (AppUserLogin)appUserLogin.get();
            updateAppUserLogin.setLogoutDate(Instant.now());
            this.appUserLoginRepository.save((Object)updateAppUserLogin);
            return true;
        }
        this.log.debug("Unable to find user login token");
        return false;
    }

    public JWTTokenDTO authenticate(String username, String password) {
        Optional appUser = this.appUserRepository.findByEmailOrMobileNumber(username, username);
        if (appUser.isPresent() && !((AppUser)appUser.get()).getRole().equals((Object)Role.AGRICULTEUR) && !((AppUser)appUser.get()).getRole().equals((Object)Role.TECHNICIEN_AGRI) && !((AppUser)appUser.get()).getRole().equals((Object)Role.DISTRIBUTOR_ADMIN)) {
            this.log.debug("User's role is other than AGRICULTEUR or TECHNICIEN AGRI or DISTRIBUTOR ADMIN");
            String message = this.i18nUtility.getMessage("authentication.authenticate.role.exception", null);
            throw new BadRequestException(message);
        }
        return this.authenticateUser(appUser, password);
    }

    private JWTTokenDTO authenticateUser(Optional<AppUser> appUser, String password) {
        if (appUser.isPresent() && appUser.get().isStatus().booleanValue()) {
            AppUser user = appUser.get();
            String hashPassword = this.passwordEncoder.encode((CharSequence)password);
            this.log.debug("password : {}", (Object)hashPassword);
            if (this.passwordEncoder.matches((CharSequence)password, user.getPassword())) {
                this.log.debug("User is present {}", (Object)user);
                JWTTokenDTO jwtTokenDTO = new JWTTokenDTO();
                this.validateLoginPassword(user, jwtTokenDTO);
                if (!jwtTokenDTO.getIsValid().booleanValue()) {
                    return jwtTokenDTO;
                }
                jwtTokenDTO.setToken(this.getToken(user));
                return jwtTokenDTO;
            }
            this.log.debug("User password combination not match.");
            String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
            throw new BadRequestException(message);
        }
        this.log.debug("User is not found.");
        String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
        throw new BadRequestException(message);
    }

    private JWTTokenDTO validateLoginPassword(AppUser appUser, JWTTokenDTO jwtTokenDTO) {
        List passwordHistory = this.passwordHistoryRepository.findByAppUserIdAndStatusOrderByCreatedDate(appUser.getId(), Boolean.valueOf(true));
        if (passwordHistory.size() < 2) {
            jwtTokenDTO.setIsValid(Boolean.valueOf(false));
            return jwtTokenDTO;
        }
        jwtTokenDTO.setIsValid(Boolean.valueOf(true));
        Instant passwordDate = ((PasswordHistory)passwordHistory.get(passwordHistory.size() - 1)).getCreatedDate();
        LocalDate lastPasswordDate = passwordDate.atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate todayDate = LocalDate.now();
        Long noOfDaysBetween = ChronoUnit.DAYS.between(lastPasswordDate, todayDate);
        if (noOfDaysBetween >= PASSWORD_CHANGE) {
            jwtTokenDTO.setExpiresIn(Integer.valueOf(0));
            jwtTokenDTO.setIsValid(Boolean.valueOf(false));
        } else if (noOfDaysBetween >= PASSWORD_WARNING && noOfDaysBetween <= PASSWORD_CHANGE) {
            Integer expiresIn = (int)(PASSWORD_CHANGE - noOfDaysBetween);
            jwtTokenDTO.setExpiresIn(expiresIn);
            this.addOrUpdatePasswordExpireNotification(appUser, expiresIn);
        }
        if (noOfDaysBetween < PASSWORD_WARNING) {
            this.addOrUpdatePasswordExpireNotification(appUser, null);
        }
        return jwtTokenDTO;
    }

    private void addOrUpdatePasswordExpireNotification(AppUser appUser, Integer expiresIn) {
        Object[] args = new Object[]{expiresIn};
        String description = this.i18nUtility.getMessage("notifications.password.expire.message", args);
        Optional existingNotification = this.notificationRepository.findByAppUserIdAndNotificationNameAndStatus(appUser.getId(), NotificationName.PASSWORD_EXPIRE, Boolean.valueOf(true));
        if (existingNotification.isPresent()) {
            if (expiresIn == null) {
                ((Notification)existingNotification.get()).setStatus(Boolean.valueOf(false));
            } else {
                ((Notification)existingNotification.get()).setExpires(Instant.now().plus((long)expiresIn.intValue(), ChronoUnit.DAYS));
                ((Notification)existingNotification.get()).setDescription(description);
            }
            this.notificationRepository.save((Object)((Notification)existingNotification.get()));
        } else if (!existingNotification.isPresent() && expiresIn != null) {
            Notification notification = new Notification();
            notification.setNotificationName(NotificationName.PASSWORD_EXPIRE);
            notification.setDescription(description);
            notification.setAppUser(appUser);
            notification.category(Category.WARNING);
            notification.setStatus(Boolean.valueOf(true));
            notification.setReadStatus(Boolean.valueOf(false));
            notification.setExpires(Instant.now().plus((long)expiresIn.intValue(), ChronoUnit.DAYS));
            this.notificationRepository.save((Object)notification);
        }
    }

    public AuthInfo authInfo() {
        return this.oktaSecurity.getAuthInfo();
    }

    public MobileAuthInfo mobileAuthInfo() {
        return this.oktaSecurity.getMobileAuthInfo();
    }

    public String authenticate(AuthenticationDTO authenticationDTO) {
        this.log.debug("code : {}", (Object)authenticationDTO);
        try {
            OktaUser oktaUser = this.oktaSecurity.authenticate(authenticationDTO.getCode());
            String email = oktaUser.getEmail();
            String preferredUsername = oktaUser.getPreferred_username();
            this.log.debug("oktaUser=> email: {} , preferredUsername: {}", (Object)email, (Object)preferredUsername);
            Optional appUser = this.appUserRepository.findByEmail(preferredUsername);
            if (!appUser.isPresent()) {
                appUser = this.appUserRepository.findByEmail(email);
            }
            if (appUser.isPresent() && ((AppUser)appUser.get()).isStatus().booleanValue()) {
                return this.getToken((AppUser)appUser.get());
            }
            this.log.debug("User is not found.");
            String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
            throw new BadRequestException(message);
        }
        catch (RestClientException ex) {
            throw new BadRequestException(ex.getMessage());
        }
    }

    public String authenticateMobile(String accessToken) {
        try {
            OktaUser oktaUser = this.oktaSecurity.authenticateMobile(accessToken);
            String email = oktaUser.getEmail();
            String preferredUsername = oktaUser.getPreferred_username();
            this.log.debug("oktaUser=> email: {} , preferredUsername: {}", (Object)email, (Object)preferredUsername);
            Optional appUser = this.appUserRepository.findByEmail(preferredUsername);
            if (!appUser.isPresent()) {
                appUser = this.appUserRepository.findByEmail(email);
            }
            if (appUser.isPresent() && ((AppUser)appUser.get()).isStatus().booleanValue()) {
                return this.getToken((AppUser)appUser.get());
            }
            this.log.debug("User is not present");
            String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
            throw new BadRequestException(message);
        }
        catch (RestClientException ex) {
            throw new BadRequestException(ex.getMessage());
        }
    }

    private String getToken(AppUser user) {
        if (user.isStatus().booleanValue()) {
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            SimpleGrantedAuthority authority = new SimpleGrantedAuthority(user.getRole().name());
            authorities.add(authority);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getId(), (Object)user.getEmail(), authorities);
            String token = this.tokenProvider.createToken((Authentication)authentication);
            AppUserLogin appUserLogin = new AppUserLogin();
            appUserLogin.setAppUser(user);
            appUserLogin.setLoginDate(Instant.now());
            appUserLogin.setToken(token);
            this.appUserLoginRepository.save((Object)appUserLogin);
            return token;
        }
        this.log.debug("User is present but inactive throw AuthenticationException");
        String message = this.i18nUtility.getMessage("authentication.authenticate.user.invalid.password.exception", null);
        throw new BadRequestException(message);
    }

    public JWTTokenDTO userSignup(AppUserDTO appUserDTO, AppUserDeviceDTO appUserDeviceDTO) {
        if (appUserDTO.getRole().equals(Role.AGRICULTEUR.getValue()) || appUserDTO.getRole().equals(Role.TECHNICIEN_AGRI.getValue()) || appUserDTO.getRole().equals(Role.DISTRIBUTOR_ADMIN.getValue())) {
            Optional appUserExistWithIdNumber;
            Optional appUserExistWithEmail;
            JWTTokenDTO jwtTokenDTO = new JWTTokenDTO();
            if (appUserDTO.getEmail() != null && (appUserExistWithEmail = this.appUserRepository.findByEmail(appUserDTO.getEmail())).isPresent() && ((AppUser)appUserExistWithEmail.get()).isStatus().booleanValue()) {
                this.log.debug("User already exist with email.");
                String message = this.i18nUtility.getMessage("authentication.signup.mobile.user.email.exception", null);
                throw new BadRequestException(message);
            }
            Optional appUserExistWithMobile = this.appUserRepository.findByMobileNumber(appUserDTO.getMobileNumber());
            if (appUserExistWithMobile.isPresent()) {
                if (((AppUser)appUserExistWithMobile.get()).isStatus().booleanValue()) {
                    this.log.debug("User already exist with mobile number.");
                    String message = this.i18nUtility.getMessage("authentication.signup.mobile.user.number.exception", null);
                    throw new BadRequestException(message);
                }
                appUserDTO.setId(((AppUser)appUserExistWithMobile.get()).getId());
                appUserDTO.setStatus(Boolean.valueOf(true));
            }
            if ((appUserExistWithIdNumber = this.appUserRepository.findByIdNumber(appUserDTO.getIdNumber())).isPresent()) {
                this.log.debug("User already exists with id number");
                String message = this.i18nUtility.getMessage("authentication.signup.mobile.id.number.exception", null);
                throw new BadRequestException(message);
            }
            if (appUserDTO.getLatitude() != null && appUserDTO.getLongitude() != null) {
                CompletableFuture addressFuture = this.geoUtility.getAddressFromGeoLocation(appUserDTO.getLatitude().doubleValue(), appUserDTO.getLongitude().doubleValue());
                this.log.debug("Current location addresss {}", (Object)addressFuture);
                this.log.debug("Current location latitude {} and longitude {}", (Object)appUserDTO.getLatitude(), (Object)appUserDTO.getLongitude());
                try {
                    Optional state;
                    Long countryId = null;
                    Long stateId = null;
                    Optional country = this.countryRepository.findByNameIgnoreCase(((GeoUtility.Address)addressFuture.get()).getCountry());
                    if (country.isPresent()) {
                        countryId = ((Country)country.get()).getId();
                    }
                    if (countryId != null && (state = this.stateRepository.findByCountryIdAndNameIgnoreCaseOrCodeIgnoreCase(countryId, ((GeoUtility.Address)addressFuture.get()).getState(), ((GeoUtility.Address)addressFuture.get()).getState())).isPresent()) {
                        stateId = ((State)state.get()).getId();
                    }
                    this.log.debug("current location countryId {} and stateId {}", (Object)countryId, stateId);
                    appUserDTO.setDistrict(((GeoUtility.Address)addressFuture.get()).getDistrict());
                    appUserDTO.setStateId(stateId);
                    appUserDTO.setCountryId(countryId);
                    appUserDTO.setPincode(((GeoUtility.Address)addressFuture.get()).getPostalCode());
                }
                catch (Exception e) {
                    this.log.error(e.getMessage());
                    String message = this.i18nUtility.getMessage("custom.error.message", null);
                    throw new BadRequestException(message);
                }
            }
            if (StringUtils.isBlank((CharSequence)appUserDTO.getEmail())) {
                appUserDTO.setEmail(null);
            }
            AppUser user = this.appUserMapper.toEntity(appUserDTO);
            user.setPassword(this.appUserService.validatePassword(user, user.getPassword()));
            user = (AppUser)this.appUserRepository.save((Object)user);
            if (appUserDeviceDTO != null) {
                appUserDeviceDTO.setAppUserId(user.getId());
                this.appUserDeviceService.save(appUserDeviceDTO);
            }
            this.log.debug("User is present {}", (Object)user);
            jwtTokenDTO.setToken(this.getToken(user));
            return jwtTokenDTO;
        }
        this.log.debug("Invalid user role.");
        String message = this.i18nUtility.getMessage("authentication.authenticate.create.user.role.exception", null);
        throw new BadRequestException(message);
    }

    public Boolean resetPassword(String email, String gRecaptcha, String timeZone) {
        try {
            Optional appUser = this.appUserRepository.findByEmail(email);
            if (!appUser.isPresent()) {
                this.log.debug("User is not found.");
                String message = this.i18nUtility.getMessage("authentication.authenticate.role.exception", null);
                throw new BadRequestException(message);
            }
            this.checkRecentPasswordResetEmail(appUser);
            this.checkPasswordTokenAvailabilityAndSendEmail(appUser, timeZone);
        }
        catch (Exception e) {
            throw new BadRequestException(e.getMessage());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkRecentPasswordResetEmail(Optional<AppUser> appUser) {
        Optional passwordResetEmailLog = this.passwordResetEmailLogRepository.findTopByAppUserIdOrderByRequestedDateDesc(appUser.get().getId());
        if (!passwordResetEmailLog.isPresent()) {
            this.addPasswordResetEmailLog(appUser, Long.valueOf(0L), passwordResetEmailLog);
            return;
        }
        Long duration = ChronoUnit.HOURS.between(((PasswordResetEmailLog)passwordResetEmailLog.get()).getRequestedDate(), Instant.now());
        if (((PasswordResetEmailLog)passwordResetEmailLog.get()).getDayCount() >= PASSWORD_RESET_EMAIL_LIMIT && !((PasswordResetEmailLog)passwordResetEmailLog.get()).getRequestedDate().isBefore(Instant.now())) {
            this.log.error("Password reset day limit exceeded");
            String message = this.i18nUtility.getMessage("password.reset.email.limit.exception", null);
            throw new BadRequestException(message);
        }
        if (duration >= PASSWORD_RESET_DURATION) {
            this.addPasswordResetEmailLog(appUser, duration, passwordResetEmailLog);
            return;
        }
        this.log.error("Password reset duration is less than 1 hour");
        String message = this.i18nUtility.getMessage("password.reset.email.duration.exception", null);
        throw new BadRequestException(message);
    }

    private void addPasswordResetEmailLog(Optional<AppUser> appUser, Long duration, Optional<PasswordResetEmailLog> passwordResetEmailLog) {
        PasswordResetEmailLog newPasswordResetEmailLog = new PasswordResetEmailLog();
        newPasswordResetEmailLog.setAppUser(appUser.get());
        if (passwordResetEmailLog.isPresent() && passwordResetEmailLog.get().getRequestedDate().isBefore(Instant.now()) || duration == 0L) {
            newPasswordResetEmailLog.setDayCount(Long.valueOf(1L));
        } else {
            newPasswordResetEmailLog.setDayCount(Long.valueOf(passwordResetEmailLog.get().getDayCount() + 1L));
        }
        newPasswordResetEmailLog.setRequestedEmail(appUser.get().getEmail());
        newPasswordResetEmailLog.setRequestedDate(Instant.now());
        newPasswordResetEmailLog.setStatus(Boolean.valueOf(true));
        this.passwordResetEmailLogRepository.save((Object)newPasswordResetEmailLog);
    }

    private void checkPasswordTokenAvailabilityAndSendEmail(Optional<AppUser> appUser, String timeZone) {
        Optional activePasswordResetToken = this.passwordResetTokenRepository.findByStatusAndAppUserId(Boolean.valueOf(true), appUser.get().getId());
        Instant now = Instant.now();
        if (activePasswordResetToken.isPresent()) {
            if (now.isBefore(((PasswordResetToken)activePasswordResetToken.get()).getExpireDate())) {
                this.log.error("Password reset email already sent");
                String message = this.i18nUtility.getMessage("password.reset.email.link.exception", null);
                throw new BadRequestException(message);
            }
            this.generateTokenAndSendEmail(activePasswordResetToken, appUser, timeZone);
        } else {
            this.generateTokenAndSendEmail(activePasswordResetToken, appUser, timeZone);
        }
    }

    private void generateTokenAndSendEmail(Optional<PasswordResetToken> activePasswordResetToken, Optional<AppUser> appUser, String timeZone) {
        if (activePasswordResetToken.isPresent()) {
            this.inactivateToken(activePasswordResetToken.get());
        }
        String token = this.passwordEncoder.encode((CharSequence)UUID.randomUUID().toString());
        String passwordResetURL = this.passwordResetEndpoint + token;
        PasswordResetToken passwordResetToken = new PasswordResetToken();
        passwordResetToken.setAppUser(appUser.get());
        passwordResetToken.setStatus(Boolean.valueOf(true));
        passwordResetToken.setExpireDate(Instant.now().plus(1L, ChronoUnit.HOURS));
        passwordResetToken.setToken(token);
        passwordResetToken.setCreatedBy(appUser.get().getId().toString());
        this.passwordResetTokenRepository.save((Object)passwordResetToken);
        this.mailUtility.sendPasswordResetEmailLink(appUser.get(), this.getTimeFromTimeZone(timeZone), passwordResetURL);
    }

    @Async(value="taskExecutor")
    private void inactivateToken(PasswordResetToken passwordResetToken) {
        passwordResetToken.setStatus(Boolean.valueOf(false));
        this.passwordResetTokenRepository.save((Object)passwordResetToken);
    }

    private String getTimeFromTimeZone(String currentTimeZone) {
        Locale locale = Locale.forLanguageTag(this.defaultLanguage);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT, locale);
        ZoneId fromTimeZone = ZoneId.of("Asia/Kolkata");
        ZoneId toTimeZone = ZoneId.of(currentTimeZone);
        LocalDateTime today = LocalDateTime.now();
        ZonedDateTime currentISTime = today.atZone(fromTimeZone);
        ZonedDateTime currentETime = currentISTime.withZoneSameInstant(toTimeZone);
        return formatter.format(currentETime.plus(1L, ChronoUnit.HOURS)).toString();
    }

    public JWTTokenDTO updatePassword(String newPassword, String token, String email, String mobileNumber, String oldPassword, String gRecaptcha, Boolean rememberMe) {
        JWTTokenDTO jwtTokenDTO = null;
        if (token != null && newPassword != null) {
            PasswordResetToken passwordResetToken = this.validatePasswordResetToken(token);
            AppUser appUser = passwordResetToken.getAppUser();
            if (appUser.getId() != null) {
                appUser.setPassword(this.appUserService.validatePassword(appUser, newPassword));
                appUser = (AppUser)this.appUserRepository.save((Object)appUser);
                this.appUserService.updatePasswordHistory(appUser);
                if (passwordResetToken.getStatus().booleanValue()) {
                    passwordResetToken.setStatus(Boolean.valueOf(false));
                    passwordResetToken.setLastModifiedBy(passwordResetToken.getAppUser().getId().toString());
                    this.passwordResetTokenRepository.save((Object)passwordResetToken);
                }
                this.addUpdatePasswordNotification(appUser, newPassword);
            }
        } else if (token == null && oldPassword != null && newPassword != null) {
            Optional appUser;
            Optional optional = appUser = email == null ? this.appUserRepository.findByMobileNumber(mobileNumber) : this.appUserRepository.findByEmail(email);
            if (appUser.isPresent()) {
                this.log.debug("user detail: " + ((AppUser)appUser.get()).toString());
                if (this.passwordEncoder.matches((CharSequence)oldPassword, ((AppUser)appUser.get()).getPassword())) {
                    this.log.debug("user password matched: ");
                    if (this.appUserService.updatePassword(((AppUser)appUser.get()).getId(), oldPassword, newPassword).booleanValue()) {
                        jwtTokenDTO = this.authenticateUser(appUser, newPassword);
                        this.addUpdatePasswordNotification((AppUser)appUser.get(), newPassword);
                        this.log.debug("returned token: " + jwtTokenDTO.toString());
                    } else {
                        this.log.debug("password not update : " + ((AppUser)appUser.get()).getId() + " " + oldPassword + " " + newPassword);
                    }
                } else {
                    this.log.debug("User password combination not match.");
                    String message = this.i18nUtility.getMessage("authentication.authenticate.role.exception", null);
                    throw new BadRequestException(message);
                }
            }
        }
        return jwtTokenDTO;
    }

    private void addUpdatePasswordNotification(AppUser appUser, String newPassword) {
        String description = null;
        if (SecurityUtils.getCurrentUserJWT().get() != "") {
            Optional loggedInUser = this.appUserRepository.findById((Object)Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get()));
            if (((AppUser)loggedInUser.get()).getId().equals(appUser.getId())) {
                description = this.i18nUtility.getMessage("notifications.password.update.message", null);
            } else {
                Object[] args = new Object[]{((AppUser)loggedInUser.get()).getUserName()};
                this.mailUtility.sendUserupdatePasswordEmail(appUser, newPassword);
                description = this.i18nUtility.getMessage("appuser.userName.update.password.message {}", args);
            }
        } else {
            description = this.i18nUtility.getMessage("notifications.password.update.message", null);
        }
        this.setNotifcationDataAndSave(appUser, description, Category.NOTIFY, NotificationName.PASSWORD_EXPIRE, Long.valueOf(5L));
    }

    public void setNotifcationDataAndSave(AppUser appUser, String description, Category category, NotificationName notificationName, Long exipresIn) {
        Notification notification = new Notification();
        notification.setNotificationName(notificationName);
        notification.setDescription(description);
        notification.setAppUser(appUser);
        notification.category(category);
        notification.setStatus(Boolean.valueOf(true));
        notification.setReadStatus(Boolean.valueOf(false));
        notification.setExpires(Instant.now().plus((long)exipresIn, ChronoUnit.DAYS));
        this.notificationRepository.save((Object)notification);
    }

    private PasswordResetToken validatePasswordResetToken(String token) {
        Optional passwordResetToken = this.passwordResetTokenRepository.findByTokenAndStatus(token, Boolean.valueOf(true));
        if (passwordResetToken.isPresent()) {
            Instant now = Instant.now();
            if (now.isBefore(((PasswordResetToken)passwordResetToken.get()).getExpireDate())) {
                return (PasswordResetToken)passwordResetToken.get();
            }
            String tokenExpiredMessage = this.i18nUtility.getMessage("password.reset.email.link.token.expired", null);
            throw new BadRequestException(tokenExpiredMessage);
        }
        String linkExpiredMessage = this.i18nUtility.getMessage("password.reset.email.link.expired.message", null);
        throw new BadRequestException(linkExpiredMessage);
    }
}

