/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.PasswordHistory;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.domain.enumeration.Role;
import com.upl.fazorstarclub.repository.AppUserRepository;
import com.upl.fazorstarclub.repository.CountryRepository;
import com.upl.fazorstarclub.repository.PasswordHistoryRepository;
import com.upl.fazorstarclub.repository.StateRepository;
import com.upl.fazorstarclub.security.SecurityUtils;
import com.upl.fazorstarclub.service.AppUserService;
import com.upl.fazorstarclub.service.PasswordHistoryService;
import com.upl.fazorstarclub.service.dto.AppUserDTO;
import com.upl.fazorstarclub.service.dto.AppUserShortDTO;
import com.upl.fazorstarclub.service.dto.PasswordHistoryDTO;
import com.upl.fazorstarclub.service.exception.BadRequestException;
import com.upl.fazorstarclub.service.mapper.AppUserMapper;
import com.upl.fazorstarclub.service.utility.AmazonUtility;
import com.upl.fazorstarclub.service.utility.GeoLocationTask;
import com.upl.fazorstarclub.service.utility.GeoUtility;
import com.upl.fazorstarclub.service.utility.I18nUtility;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(noRollbackFor={InterruptedException.class, ExecutionException.class})
public class AppUserServiceImpl
implements AppUserService {
    private final Logger log = LoggerFactory.getLogger(AppUserServiceImpl.class);
    private final AppUserRepository appUserRepository;
    private final AppUserMapper appUserMapper;
    @Autowired
    private PasswordEncoder passwordEncoder;
    private static final String UPLOAD_DIRECTORY = "appUsers";
    @Value(value="${application.allowed-image-content-types:}")
    private String allowedImageContentTypes;
    @Autowired
    private AmazonUtility amazonUtility;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private CountryRepository countryRepository;
    @Autowired
    private PasswordHistoryRepository passwordHistoryRepository;
    @Autowired
    private PasswordHistoryService passwordHistoryService;
    private static final Integer PASSWORD_HISTORY = 5;
    private final GeoUtility geoUtility;

    public AppUserServiceImpl(AppUserRepository appUserRepository, AppUserMapper appUserMapper, GeoUtility geoUtility) {
        this.appUserRepository = appUserRepository;
        this.appUserMapper = appUserMapper;
        this.geoUtility = geoUtility;
    }

    public AppUserDTO save(AppUserDTO appUserDTO) {
        Optional appUserExistWithEmail;
        this.log.debug("Request to save AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getEmail() != null && (appUserExistWithEmail = this.appUserRepository.findByEmail(appUserDTO.getEmail())).isPresent() && !((AppUser)appUserExistWithEmail.get()).getId().equals(appUserDTO.getId())) {
            this.log.debug("User already exist with email.");
            String message = this.i18nUtility.getMessage("appuser.save.email.exception", null);
            throw new BadRequestException(message);
        }
        Optional appUserExistWithMobile = this.appUserRepository.findByMobileNumber(appUserDTO.getMobileNumber());
        if (appUserExistWithMobile.isPresent() && !((AppUser)appUserExistWithMobile.get()).getId().equals(appUserDTO.getId())) {
            this.log.debug("User already exist with mobile number.");
            String message = this.i18nUtility.getMessage("appuser.save.mobile.number.exception", null);
            throw new BadRequestException(message);
        }
        AppUser appUser = this.appUserMapper.toEntity(appUserDTO);
        this.log.debug("encode user password");
        if (appUser.getId() == null) {
            appUser.setPassword(this.passwordEncoder.encode((CharSequence)appUser.getPassword()));
        } else {
            Optional existingUser = this.appUserRepository.findById((Object)appUser.getId());
            if (existingUser.isPresent()) {
                appUser.setPassword(((AppUser)existingUser.get()).getPassword());
            } else {
                appUser.setPassword(this.passwordEncoder.encode((CharSequence)appUser.getPassword()));
            }
        }
        AppUser result = (AppUser)this.appUserRepository.save((Object)appUser);
        return this.appUserMapper.toDto(result);
    }

    public AppUserDTO uploadAndSaveProfileImage(Long id, MultipartFile file) throws IOException {
        String[] elements = this.allowedImageContentTypes.split(",");
        List<String> allowedTypes = Arrays.asList(elements);
        if (allowedTypes.contains(file.getContentType())) {
            Optional appUser = this.appUserRepository.findById((Object)id);
            if (StringUtils.isNotBlank((CharSequence)((AppUser)appUser.get()).getProfilePhotoPath())) {
                this.amazonUtility.deleteFileFromS3Bucket(((AppUser)appUser.get()).getProfilePhotoPath());
            }
            String url = this.amazonUtility.uploadFile(file, "appUsers/" + id);
            ((AppUser)appUser.get()).setProfilePhotoPath(url);
            AppUser savedAppUser = (AppUser)this.appUserRepository.save((Object)((AppUser)appUser.get()));
            return this.appUserMapper.toDto(savedAppUser);
        }
        String message = this.i18nUtility.getMessage("appuser.upload.image.exception", null);
        throw new BadRequestException(message);
    }

    @Transactional(readOnly=true)
    public Page<AppUserDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all AppUsers");
        return this.appUserRepository.findAll(pageable).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<AppUserDTO> findOne(Long id) {
        this.log.debug("Request to get AppUser : {}", (Object)id);
        Optional result = this.appUserRepository.findById((Object)id);
        if (!result.isPresent()) {
            this.log.debug("User not exist with ID :" + id);
            String message = this.i18nUtility.getMessage("appuser.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        return result.map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AppUser : {}", (Object)id);
        Optional existingUser = this.appUserRepository.findById((Object)id);
        if (existingUser.isEmpty()) {
            this.log.debug("User not exist with ID :" + id);
            String message = this.i18nUtility.getMessage("appuser.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((AppUser)existingUser.get()).setStatus(Boolean.valueOf(false));
        this.appUserRepository.save((Object)((AppUser)existingUser.get()));
    }

    public String validatePassword(AppUser appUser, String password) {
        password = this.validatePassword(password);
        Boolean isContain = appUser.getEmail() != null && password.contains(appUser.getEmail()) || password.contains(appUser.getMobileNumber());
        String message = null;
        if (isContain.booleanValue()) {
            message = this.i18nUtility.getMessage("appuser.validate.password.contain.username.exception", null);
            throw new BadRequestException(message);
        }
        return this.passwordEncoder.encode((CharSequence)password);
    }

    private String validatePassword(String password) {
        Pattern pat;
        boolean result;
        String local;
        String passwordRegex = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^a-zA-Z0-9])(?!.*\\s).{8,16}$";
        String string = local = StringUtils.isBlank((CharSequence)this.i18nUtility.getLocale().getLanguage()) ? this.i18nUtility.getDefaultLocale().getLanguage() : this.i18nUtility.getLocale().getLanguage();
        if (local == "en") {
            passwordRegex = "^(?=.*\\d)(?=.*[^\\u2E80-\\u2EFF\\u2F00-\\u2FDF\\u3000-\\u303F\\u31C0-\\u31EF\\u3200-\\u32FF\\u3300-\\u33FF\\u3400-\\u3FFF\\u4000-\\u4DBF\\u4E00-\\u4FFF\\u0041-\\u005A\\u0061-\\u007A\\u3041-\\u309F\\u30A0-\\u30FF\\u31F0-\\u31FF\\uFF10-\\uFF3A\\uFF41-\\uFFEF\\u672C])(?!.*\\s).{8,16}$";
        }
        if (!(result = (pat = Pattern.compile(passwordRegex)).matcher(password).matches())) {
            String message = this.i18nUtility.getMessage("appuser.import.password.validation.exception", null);
            throw new BadRequestException(message);
        }
        return password;
    }

    public List<AppUserShortDTO> getAllNearByDistributorsOrTechnicians(Role role, BigDecimal latitude, BigDecimal longitude) {
        Long appUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        Optional appUser = this.appUserRepository.findById((Object)appUserId);
        Long countryId = null;
        Optional country = null;
        try {
            CompletableFuture addressFuture = this.geoUtility.getAddressFromGeoLocation(latitude.doubleValue(), longitude.doubleValue());
            if (addressFuture.isDone()) {
                if (((GeoUtility.Address)addressFuture.get()).getCountry() != null) {
                    country = this.countryRepository.findByNameIgnoreCase(((GeoUtility.Address)addressFuture.get()).getCountry());
                    countryId = ((Country)country.get()).getId();
                }
            } else {
                Long l = countryId = ((AppUser)appUser.get()).getCountry() != null ? ((AppUser)appUser.get()).getCountry().getId() : null;
            }
            if (countryId == null) {
                List distributors = this.appUserRepository.findByStatusAndRole(Boolean.valueOf(true), role);
                return this.appUserMapper.toShortDto(distributors);
            }
            List stateIds = this.appUserRepository.findStateIdsByStatusAndRoleAndCountryId(Boolean.valueOf(true), role.toString(), countryId);
            if (!stateIds.isEmpty()) {
                Long stateId = this.findByNearestState(country != null ? ((Country)country.get()).getName() : ((AppUser)appUser.get()).getCountry().getName(), latitude, longitude, stateIds);
                List distributors = this.appUserRepository.findByStateIdAndStatusAndRole(stateId, Boolean.valueOf(true), role);
                if (!distributors.isEmpty()) {
                    distributors = this.appUserRepository.findByStatusAndRole(Boolean.valueOf(true), role);
                    return this.appUserMapper.toShortDto(distributors);
                }
                return this.appUserMapper.toShortDto(distributors);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            String message = this.i18nUtility.getMessage("custom.error.message", null);
            throw new BadRequestException(message);
        }
        return new ArrayList<AppUserShortDTO>();
    }

    private Long findByNearestState(String countryName, BigDecimal lat, BigDecimal lon, List<Long> stateIds) {
        HashMap futureMap = new HashMap();
        HashMap<Long, Double> map = new HashMap<Long, Double>();
        try {
            List states = this.stateRepository.findByIdIn(stateIds);
            ExecutorService executorService = Executors.newFixedThreadPool(states.size());
            for (State state : states) {
                GeoLocationTask geoLocationTask = new GeoLocationTask(this.geoUtility, state.getName(), countryName, lat, lon);
                Future result = executorService.submit(geoLocationTask);
                futureMap.put(state.getId(), result);
            }
            for (Map.Entry entry : futureMap.entrySet()) {
                map.put((Long)entry.getKey(), (Double)((Future)entry.getValue()).get());
            }
            map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            executorService.shutdown();
            return (Long)map.entrySet().iterator().next().getKey();
        }
        catch (Exception e) {
            this.log.debug("Error while fetching location or calculating distance", (Throwable)e);
            String message = this.i18nUtility.getMessage("custom.error.message", null);
            throw new BadRequestException(message);
        }
    }

    public void updatePasswordHistory(AppUser appUser) {
        List passwordHistories = this.passwordHistoryRepository.findByAppUserIdAndStatusOrderByCreatedDate(appUser.getId(), Boolean.valueOf(true));
        if (passwordHistories.size() >= PASSWORD_HISTORY) {
            Long lastPassword = ((PasswordHistory)passwordHistories.get(0)).getId();
            this.passwordHistoryService.delete(lastPassword);
        }
        PasswordHistoryDTO passwordHistoryDTO = new PasswordHistoryDTO();
        passwordHistoryDTO.setAppUserId(appUser.getId());
        passwordHistoryDTO.setPassword(appUser.getPassword());
        passwordHistoryDTO.setStatus(Boolean.valueOf(true));
        this.passwordHistoryService.save(passwordHistoryDTO);
    }

    public Boolean updatePassword(Long id, String oldPassword, String newPassword) {
        this.log.debug("Update password for user : {}", (Object)id);
        Optional appUser = this.appUserRepository.findById((Object)id);
        AppUser user = (AppUser)appUser.get();
        if (!this.passwordEncoder.matches((CharSequence)oldPassword, user.getPassword())) {
            this.log.debug("old password not matching : {}", (Object)oldPassword);
            String message = this.i18nUtility.getMessage("appuser.update.password.exception", null);
            throw new BadRequestException(message);
        }
        user.setPassword(this.validatePassword(user, newPassword));
        user = (AppUser)this.appUserRepository.save((Object)user);
        this.updatePasswordHistory(user);
        return true;
    }
}

