/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service.impl;

import com.upl.fazorstarclub.domain.AppUserDevice;
import com.upl.fazorstarclub.repository.AppUserDeviceRepository;
import com.upl.fazorstarclub.service.AppUserDeviceService;
import com.upl.fazorstarclub.service.dto.AppUserDeviceDTO;
import com.upl.fazorstarclub.service.mapper.AppUserDeviceMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppUserDeviceServiceImpl
implements AppUserDeviceService {
    private final Logger log = LoggerFactory.getLogger(AppUserDeviceServiceImpl.class);
    private final AppUserDeviceRepository appUserDeviceRepository;
    private final AppUserDeviceMapper appUserDeviceMapper;

    public AppUserDeviceServiceImpl(AppUserDeviceRepository appUserDeviceRepository, AppUserDeviceMapper appUserDeviceMapper) {
        this.appUserDeviceRepository = appUserDeviceRepository;
        this.appUserDeviceMapper = appUserDeviceMapper;
    }

    public AppUserDeviceDTO save(AppUserDeviceDTO appUserDeviceDTO) {
        Optional existing;
        this.log.debug("Request to save AppUserDevice : {}", (Object)appUserDeviceDTO);
        if (appUserDeviceDTO.getAppUserId() != null && (existing = this.appUserDeviceRepository.findByAppUserId(appUserDeviceDTO.getAppUserId())).isPresent()) {
            appUserDeviceDTO.setId(((AppUserDevice)existing.get()).getId());
        }
        AppUserDevice appUserDevice = this.appUserDeviceMapper.toEntity(appUserDeviceDTO);
        appUserDevice = (AppUserDevice)this.appUserDeviceRepository.save((Object)appUserDevice);
        return this.appUserDeviceMapper.toDto(appUserDevice);
    }
}

