/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.Weather;
import com.upl.fazorstarclub.domain.Weather_;
import com.upl.fazorstarclub.repository.WeatherRepository;
import com.upl.fazorstarclub.service.criteria.WeatherCriteria;
import com.upl.fazorstarclub.service.dto.WeatherDTO;
import com.upl.fazorstarclub.service.mapper.WeatherMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class WeatherQueryService
extends QueryService<Weather> {
    private final Logger log = LoggerFactory.getLogger(WeatherQueryService.class);
    private final WeatherRepository weatherRepository;
    private final WeatherMapper weatherMapper;

    public WeatherQueryService(WeatherRepository weatherRepository, WeatherMapper weatherMapper) {
        this.weatherRepository = weatherRepository;
        this.weatherMapper = weatherMapper;
    }

    @Transactional(readOnly=true)
    public List<WeatherDTO> findByCriteria(WeatherCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.weatherMapper.toDto(this.weatherRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<WeatherDTO> findByCriteria(WeatherCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.weatherRepository.findAll(specification, page).map(arg_0 -> ((WeatherMapper)this.weatherMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(WeatherCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.weatherRepository.count(specification);
    }

    protected Specification<Weather> createSpecification(WeatherCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Weather_.id));
            }
            if (criteria.getMoonriseTs() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMoonriseTs(), Weather_.moonriseTs));
            }
            if (criteria.getWindCdir() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getWindCdir(), Weather_.windCdir));
            }
            if (criteria.getRh() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getRh(), Weather_.rh));
            }
            if (criteria.getPres() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getPres(), Weather_.pres));
            }
            if (criteria.getHighTemp() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getHighTemp(), Weather_.highTemp));
            }
            if (criteria.getOzone() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getOzone(), Weather_.ozone));
            }
            if (criteria.getMoonPhase() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMoonPhase(), Weather_.moonPhase));
            }
            if (criteria.getWindGustSpd() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getWindGustSpd(), Weather_.windGustSpd));
            }
            if (criteria.getSnowDepth() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getSnowDepth(), Weather_.snowDepth));
            }
            if (criteria.getClouds() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getClouds(), Weather_.clouds));
            }
            if (criteria.getTs() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTs(), Weather_.ts));
            }
            if (criteria.getSunriseTs() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getSunriseTs(), Weather_.sunriseTs));
            }
            if (criteria.getAppMinTemp() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getAppMinTemp(), Weather_.appMinTemp));
            }
            if (criteria.getWindSpd() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getWindSpd(), Weather_.windSpd));
            }
            if (criteria.getPop() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPop(), Weather_.pop));
            }
            if (criteria.getWindCdirFull() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getWindCdirFull(), Weather_.windCdirFull));
            }
            if (criteria.getSlp() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getSlp(), Weather_.slp));
            }
            if (criteria.getMoonPhaseLunation() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMoonPhaseLunation(), Weather_.moonPhaseLunation));
            }
            if (criteria.getAppMaxTemp() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getAppMaxTemp(), Weather_.appMaxTemp));
            }
            if (criteria.getVis() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getVis(), Weather_.vis));
            }
            if (criteria.getDewpt() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDewpt(), Weather_.dewpt));
            }
            if (criteria.getSnow() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getSnow(), Weather_.snow));
            }
            if (criteria.getUv() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getUv(), Weather_.uv));
            }
            if (criteria.getIcon() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getIcon(), Weather_.icon));
            }
            if (criteria.getCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCode(), Weather_.code));
            }
            if (criteria.getDescription() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDescription(), Weather_.description));
            }
            if (criteria.getWindDir() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getWindDir(), Weather_.windDir));
            }
            if (criteria.getMaxDhi() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMaxDhi(), Weather_.maxDhi));
            }
            if (criteria.getCloudsHi() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCloudsHi(), Weather_.cloudsHi));
            }
            if (criteria.getLowTemp() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getLowTemp(), Weather_.lowTemp));
            }
            if (criteria.getMaxTemp() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMaxTemp(), Weather_.maxTemp));
            }
            if (criteria.getMinTemp() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMinTemp(), Weather_.minTemp));
            }
            if (criteria.getMoonsetTs() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMoonsetTs(), Weather_.moonsetTs));
            }
            if (criteria.getTemp() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTemp(), Weather_.temp));
            }
            if (criteria.getCloudsMid() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCloudsMid(), Weather_.cloudsMid));
            }
            if (criteria.getCloudsLow() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCloudsLow(), Weather_.cloudsLow));
            }
            if (criteria.getDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDate(), Weather_.date));
            }
            if (criteria.getBulkSoilDensity() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getBulkSoilDensity(), Weather_.bulkSoilDensity));
            }
            if (criteria.getSkinTempMax() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSkinTempMax(), Weather_.skinTempMax));
            }
            if (criteria.getSkinTempAvg() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSkinTempAvg(), Weather_.skinTempAvg));
            }
            if (criteria.getSkinTempMin() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSkinTempMin(), Weather_.skinTempMin));
            }
            if (criteria.getTemp2mAvg() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getTemp2mAvg(), Weather_.temp2mAvg));
            }
            if (criteria.getPrecip() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getPrecip(), Weather_.precip));
            }
            if (criteria.getSpecificHumidity() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSpecificHumidity(), Weather_.specificHumidity));
            }
            if (criteria.getEvapotranspiration() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getEvapotranspiration(), Weather_.evapotranspiration));
            }
            if (criteria.getPresAvg() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getPresAvg(), Weather_.presAvg));
            }
            if (criteria.getWind10mSpdAvg() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getWind10mSpdAvg(), Weather_.wind10mSpdAvg));
            }
            if (criteria.getDlwrfAvg() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDlwrfAvg(), Weather_.dlwrfAvg));
            }
            if (criteria.getDlwrfMax() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDlwrfMax(), Weather_.dlwrfMax));
            }
            if (criteria.getDswrfAvg() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDswrfAvg(), Weather_.dswrfAvg));
            }
            if (criteria.getDswrfMax() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDswrfMax(), Weather_.dswrfMax));
            }
            if (criteria.getDswrfNet() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDswrfNet(), Weather_.dswrfNet));
            }
            if (criteria.getDlwrfNet() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDlwrfNet(), Weather_.dlwrfNet));
            }
            if (criteria.getSoilm0To10cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSoilm0To10cm(), Weather_.soilm0To10cm));
            }
            if (criteria.getSoilm10To40cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSoilm10To40cm(), Weather_.soilm10To40cm));
            }
            if (criteria.getSoilm40To100cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSoilm40To100cm(), Weather_.soilm40To100cm));
            }
            if (criteria.getSoilm100To200cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSoilm100To200cm(), Weather_.soilm100To200cm));
            }
            if (criteria.getvSoilm0To10cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getvSoilm0To10cm(), Weather_.vSoilm0To10cm));
            }
            if (criteria.getvSoilm10To40cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getvSoilm10To40cm(), Weather_.vSoilm10To40cm));
            }
            if (criteria.getvSoilm40To100cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getvSoilm40To100cm(), Weather_.vSoilm40To100cm));
            }
            if (criteria.getvSoilm100To200cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getvSoilm100To200cm(), Weather_.vSoilm100To200cm));
            }
            if (criteria.getSoilt0To10cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSoilt0To10cm(), Weather_.soilt0To10cm));
            }
            if (criteria.getSoilt10To40cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSoilt10To40cm(), Weather_.soilt10To40cm));
            }
            if (criteria.getSoilt40To100cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSoilt40To100cm(), Weather_.soilt40To100cm));
            }
            if (criteria.getSoilt100To200cm() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getSoilt100To200cm(), Weather_.soilt100To200cm));
            }
            if (criteria.getLatitude() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getLatitude(), Weather_.latitude));
            }
            if (criteria.getLongitude() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getLongitude(), Weather_.longitude));
            }
            if (criteria.getAverageSoilMoisture() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getAverageSoilMoisture(), Weather_.averageSoilMoisture));
            }
            if (criteria.getAverageVolumetricSoilMoisture() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getAverageVolumetricSoilMoisture(), Weather_.averageVolumetricSoilMoisture));
            }
            if (criteria.getAverageSoilTemperature() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getAverageSoilTemperature(), Weather_.averageSoilTemperature));
            }
            if (criteria.getProcessFlag() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getProcessFlag(), Weather_.processFlag));
            }
        }
        return specification;
    }
}

