/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.AppUser_;
import com.upl.fazorstarclub.domain.Irrigation_;
import com.upl.fazorstarclub.domain.PreviousCrop_;
import com.upl.fazorstarclub.domain.SeedVariety_;
import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.domain.UserFarm_;
import com.upl.fazorstarclub.repository.UserFarmRepository;
import com.upl.fazorstarclub.service.criteria.UserFarmCriteria;
import com.upl.fazorstarclub.service.dto.UserFarmDTO;
import com.upl.fazorstarclub.service.mapper.UserFarmMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class UserFarmQueryService
extends QueryService<UserFarm> {
    private final Logger log = LoggerFactory.getLogger(UserFarmQueryService.class);
    private final UserFarmRepository userFarmRepository;
    private final UserFarmMapper userFarmMapper;

    public UserFarmQueryService(UserFarmRepository userFarmRepository, UserFarmMapper userFarmMapper) {
        this.userFarmRepository = userFarmRepository;
        this.userFarmMapper = userFarmMapper;
    }

    @Transactional(readOnly=true)
    public List<UserFarmDTO> findByCriteria(UserFarmCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.userFarmMapper.toDto(this.userFarmRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<UserFarmDTO> findByCriteria(UserFarmCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.userFarmRepository.findAll(specification, page).map(arg_0 -> ((UserFarmMapper)this.userFarmMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(UserFarmCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.userFarmRepository.count(specification);
    }

    protected Specification<UserFarm> createSpecification(UserFarmCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), UserFarm_.id));
            }
            if (criteria.getPlantingDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getPlantingDate(), UserFarm_.plantingDate));
            }
            if (criteria.getPlotName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPlotName(), UserFarm_.plotName));
            }
            if (criteria.getLatitude() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getLatitude(), UserFarm_.latitude));
            }
            if (criteria.getLongitude() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getLongitude(), UserFarm_.longitude));
            }
            if (criteria.getInterRow() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getInterRow(), UserFarm_.interRow));
            }
            if (criteria.getDistributorName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDistributorName(), UserFarm_.distributorName));
            }
            if (criteria.getMarketType() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getMarketType(), UserFarm_.marketType));
            }
            if (criteria.getTypeOfSoil() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getTypeOfSoil(), UserFarm_.typeOfSoil));
            }
            if (criteria.getSeedVarietyId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getSeedVarietyId(), root -> root.join(UserFarm_.seedVariety, JoinType.LEFT).get(SeedVariety_.id)));
            }
            if (criteria.getPreviousCropId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getPreviousCropId(), root -> root.join(UserFarm_.previousCrop, JoinType.LEFT).get(PreviousCrop_.id)));
            }
            if (criteria.getIrrigationId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getIrrigationId(), root -> root.join(UserFarm_.irrigation, JoinType.LEFT).get(Irrigation_.id)));
            }
            if (criteria.getAppUserId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getAppUserId(), root -> root.join(UserFarm_.appUser, JoinType.LEFT).get(AppUser_.id)));
            }
        }
        return specification;
    }
}

