/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.Topic;
import com.upl.fazorstarclub.domain.TopicImage_;
import com.upl.fazorstarclub.domain.Topic_;
import com.upl.fazorstarclub.repository.TopicRepository;
import com.upl.fazorstarclub.service.criteria.TopicCriteria;
import com.upl.fazorstarclub.service.dto.TopicDTO;
import com.upl.fazorstarclub.service.mapper.TopicMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class TopicQueryService
extends QueryService<Topic> {
    private final Logger log = LoggerFactory.getLogger(TopicQueryService.class);
    private final TopicRepository topicRepository;
    private final TopicMapper topicMapper;

    public TopicQueryService(TopicRepository topicRepository, TopicMapper topicMapper) {
        this.topicRepository = topicRepository;
        this.topicMapper = topicMapper;
    }

    @Transactional(readOnly=true)
    public List<TopicDTO> findByCriteria(TopicCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.topicMapper.toDto(this.topicRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<TopicDTO> findByCriteria(TopicCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.topicRepository.findAll(specification, page).map(arg_0 -> ((TopicMapper)this.topicMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(TopicCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.topicRepository.count(specification);
    }

    protected Specification<Topic> createSpecification(TopicCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Topic_.id));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), Topic_.status));
            }
            if (criteria.getTopicName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTopicName(), Topic_.topicName));
            }
            if (criteria.getTopicCategory() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getTopicCategory(), Topic_.topicCategory));
            }
            if (criteria.getTopicImagesId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getTopicImagesId(), root -> root.join(Topic_.topicImages, JoinType.LEFT).get(TopicImage_.id)));
            }
        }
        return specification;
    }
}

