/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.Country_;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.domain.State_;
import com.upl.fazorstarclub.repository.StateRepository;
import com.upl.fazorstarclub.service.criteria.StateCriteria;
import com.upl.fazorstarclub.service.dto.StateDTO;
import com.upl.fazorstarclub.service.mapper.StateMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class StateQueryService
extends QueryService<State> {
    private final Logger log = LoggerFactory.getLogger(StateQueryService.class);
    private final StateRepository stateRepository;
    private final StateMapper stateMapper;

    public StateQueryService(StateRepository stateRepository, StateMapper stateMapper) {
        this.stateRepository = stateRepository;
        this.stateMapper = stateMapper;
    }

    @Transactional(readOnly=true)
    public List<StateDTO> findByCriteria(StateCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.stateMapper.toDto(this.stateRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<StateDTO> findByCriteria(StateCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.stateRepository.findAll(specification, page).map(arg_0 -> ((StateMapper)this.stateMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(StateCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.stateRepository.count(specification);
    }

    protected Specification<State> createSpecification(StateCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), State_.id));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), State_.name));
            }
            if (criteria.getCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCode(), State_.code));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), State_.status));
            }
            if (criteria.getCountryId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getCountryId(), root -> root.join(State_.country, JoinType.LEFT).get(Country_.id)));
            }
        }
        return specification;
    }
}

