/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.ProductApplication;
import com.upl.fazorstarclub.domain.ProductApplication_;
import com.upl.fazorstarclub.repository.ProductApplicationRepository;
import com.upl.fazorstarclub.service.criteria.ProductApplicationCriteria;
import com.upl.fazorstarclub.service.dto.ProductApplicationDTO;
import com.upl.fazorstarclub.service.mapper.ProductApplicationMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class ProductApplicationQueryService
extends QueryService<ProductApplication> {
    private final Logger log = LoggerFactory.getLogger(ProductApplicationQueryService.class);
    private final ProductApplicationRepository productApplicationRepository;
    private final ProductApplicationMapper productApplicationMapper;

    public ProductApplicationQueryService(ProductApplicationRepository productApplicationRepository, ProductApplicationMapper productApplicationMapper) {
        this.productApplicationRepository = productApplicationRepository;
        this.productApplicationMapper = productApplicationMapper;
    }

    @Transactional(readOnly=true)
    public List<ProductApplicationDTO> findByCriteria(ProductApplicationCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.productApplicationMapper.toDto(this.productApplicationRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<ProductApplicationDTO> findByCriteria(ProductApplicationCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.productApplicationRepository.findAll(specification, page).map(arg_0 -> ((ProductApplicationMapper)this.productApplicationMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(ProductApplicationCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.productApplicationRepository.count(specification);
    }

    protected Specification<ProductApplication> createSpecification(ProductApplicationCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), ProductApplication_.id));
            }
            if (criteria.getApplicationDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getApplicationDate(), ProductApplication_.applicationDate));
            }
            if (criteria.getPotatoEmergence() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getPotatoEmergence(), ProductApplication_.potatoEmergence));
            }
        }
        return specification;
    }
}

