/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.MasterPest_;
import com.upl.fazorstarclub.domain.Pest;
import com.upl.fazorstarclub.domain.Pest_;
import com.upl.fazorstarclub.domain.UserFarm_;
import com.upl.fazorstarclub.repository.PestRepository;
import com.upl.fazorstarclub.service.criteria.PestCriteria;
import com.upl.fazorstarclub.service.dto.PestDTO;
import com.upl.fazorstarclub.service.mapper.PestMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class PestQueryService
extends QueryService<Pest> {
    private final Logger log = LoggerFactory.getLogger(PestQueryService.class);
    private final PestRepository pestRepository;
    private final PestMapper pestMapper;

    public PestQueryService(PestRepository pestRepository, PestMapper pestMapper) {
        this.pestRepository = pestRepository;
        this.pestMapper = pestMapper;
    }

    @Transactional(readOnly=true)
    public List<PestDTO> findByCriteria(PestCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.pestMapper.toDto(this.pestRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<PestDTO> findByCriteria(PestCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.pestRepository.findAll(specification, page).map(arg_0 -> ((PestMapper)this.pestMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(PestCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.pestRepository.count(specification);
    }

    protected Specification<Pest> createSpecification(PestCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Pest_.id));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), Pest_.name));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), Pest_.status));
            }
            if (criteria.getLevelOfPressure() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getLevelOfPressure(), Pest_.levelOfPressure));
            }
            if (criteria.getMasterPestId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getMasterPestId(), root -> root.join(Pest_.masterPest, JoinType.LEFT).get(MasterPest_.id)));
            }
            if (criteria.getUserFarmId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getUserFarmId(), root -> root.join(Pest_.userFarm, JoinType.LEFT).get(UserFarm_.id)));
            }
        }
        return specification;
    }
}

