/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.Disease;
import com.upl.fazorstarclub.domain.Disease_;
import com.upl.fazorstarclub.domain.MasterDisease_;
import com.upl.fazorstarclub.domain.UserFarm_;
import com.upl.fazorstarclub.repository.DiseaseRepository;
import com.upl.fazorstarclub.service.criteria.DiseaseCriteria;
import com.upl.fazorstarclub.service.dto.DiseaseDTO;
import com.upl.fazorstarclub.service.mapper.DiseaseMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class DiseaseQueryService
extends QueryService<Disease> {
    private final Logger log = LoggerFactory.getLogger(DiseaseQueryService.class);
    private final DiseaseRepository diseaseRepository;
    private final DiseaseMapper diseaseMapper;

    public DiseaseQueryService(DiseaseRepository diseaseRepository, DiseaseMapper diseaseMapper) {
        this.diseaseRepository = diseaseRepository;
        this.diseaseMapper = diseaseMapper;
    }

    @Transactional(readOnly=true)
    public List<DiseaseDTO> findByCriteria(DiseaseCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.diseaseMapper.toDto(this.diseaseRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<DiseaseDTO> findByCriteria(DiseaseCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.diseaseRepository.findAll(specification, page).map(arg_0 -> ((DiseaseMapper)this.diseaseMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(DiseaseCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.diseaseRepository.count(specification);
    }

    protected Specification<Disease> createSpecification(DiseaseCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Disease_.id));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), Disease_.name));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), Disease_.status));
            }
            if (criteria.getLevelOfPressure() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getLevelOfPressure(), Disease_.levelOfPressure));
            }
            if (criteria.getMasterDiseaseId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getMasterDiseaseId(), root -> root.join(Disease_.masterDisease, JoinType.LEFT).get(MasterDisease_.id)));
            }
            if (criteria.getUserFarmId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getUserFarmId(), root -> root.join(Disease_.userFarm, JoinType.LEFT).get(UserFarm_.id)));
            }
        }
        return specification;
    }
}

