/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.Debate;
import com.upl.fazorstarclub.domain.Debate_;
import com.upl.fazorstarclub.repository.DebateRepository;
import com.upl.fazorstarclub.service.criteria.DebateCriteria;
import com.upl.fazorstarclub.service.dto.DebateDTO;
import com.upl.fazorstarclub.service.mapper.DebateMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class DebateQueryService
extends QueryService<Debate> {
    private final Logger log = LoggerFactory.getLogger(DebateQueryService.class);
    private final DebateRepository debateRepository;
    private final DebateMapper debateMapper;

    public DebateQueryService(DebateRepository debateRepository, DebateMapper debateMapper) {
        this.debateRepository = debateRepository;
        this.debateMapper = debateMapper;
    }

    @Transactional(readOnly=true)
    public List<DebateDTO> findByCriteria(DebateCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.debateMapper.toDto(this.debateRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<DebateDTO> findByCriteria(DebateCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.debateRepository.findAll(specification, page).map(arg_0 -> ((DebateMapper)this.debateMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(DebateCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.debateRepository.count(specification);
    }

    protected Specification<Debate> createSpecification(DebateCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Debate_.id));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), Debate_.name));
            }
            if (criteria.getImage() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getImage(), Debate_.image));
            }
            if (criteria.getStartDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getStartDate(), Debate_.startDate));
            }
            if (criteria.getEndDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getEndDate(), Debate_.endDate));
            }
        }
        return specification;
    }
}

