/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.DataCollection;
import com.upl.fazorstarclub.domain.DataCollection_;
import com.upl.fazorstarclub.domain.UserFarm_;
import com.upl.fazorstarclub.repository.DataCollectionRepository;
import com.upl.fazorstarclub.service.criteria.DataCollectionCriteria;
import com.upl.fazorstarclub.service.dto.DataCollectionDTO;
import com.upl.fazorstarclub.service.mapper.DataCollectionMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class DataCollectionQueryService
extends QueryService<DataCollection> {
    private final Logger log = LoggerFactory.getLogger(DataCollectionQueryService.class);
    private final DataCollectionRepository dataCollectionRepository;
    private final DataCollectionMapper dataCollectionMapper;

    public DataCollectionQueryService(DataCollectionRepository dataCollectionRepository, DataCollectionMapper dataCollectionMapper) {
        this.dataCollectionRepository = dataCollectionRepository;
        this.dataCollectionMapper = dataCollectionMapper;
    }

    @Transactional(readOnly=true)
    public List<DataCollectionDTO> findByCriteria(DataCollectionCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.dataCollectionMapper.toDto(this.dataCollectionRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<DataCollectionDTO> findByCriteria(DataCollectionCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.dataCollectionRepository.findAll(specification, page).map(arg_0 -> ((DataCollectionMapper)this.dataCollectionMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(DataCollectionCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.dataCollectionRepository.count(specification);
    }

    protected Specification<DataCollection> createSpecification(DataCollectionCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), DataCollection_.id));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), DataCollection_.status));
            }
            if (criteria.getEmergenceDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getEmergenceDate(), DataCollection_.emergenceDate));
            }
            if (criteria.getHaulmDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getHaulmDate(), DataCollection_.haulmDate));
            }
            if (criteria.getDataCollectionDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getDataCollectionDate(), DataCollection_.dataCollectionDate));
            }
            if (criteria.getTotalNumberOfTuberPlant() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getTotalNumberOfTuberPlant(), DataCollection_.totalNumberOfTuberPlant));
            }
            if (criteria.getTuberPlant25mmCount() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getTuberPlant25mmCount(), DataCollection_.tuberPlant25mmCount));
            }
            if (criteria.getTuberPlant35mmCount() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getTuberPlant35mmCount(), DataCollection_.tuberPlant35mmCount));
            }
            if (criteria.getTuberPlant25mmPercentage() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getTuberPlant25mmPercentage(), DataCollection_.tuberPlant25mmPercentage));
            }
            if (criteria.getTuberPlant35mmPercentage() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getTuberPlant35mmPercentage(), DataCollection_.tuberPlant35mmPercentage));
            }
            if (criteria.getUserFarmId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getUserFarmId(), root -> root.join(DataCollection_.userFarm, JoinType.LEFT).get(UserFarm_.id)));
            }
        }
        return specification;
    }
}

