/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.Country_;
import com.upl.fazorstarclub.repository.CountryRepository;
import com.upl.fazorstarclub.service.criteria.CountryCriteria;
import com.upl.fazorstarclub.service.dto.CountryDTO;
import com.upl.fazorstarclub.service.mapper.CountryMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class CountryQueryService
extends QueryService<Country> {
    private final Logger log = LoggerFactory.getLogger(CountryQueryService.class);
    private final CountryRepository countryRepository;
    private final CountryMapper countryMapper;

    public CountryQueryService(CountryRepository countryRepository, CountryMapper countryMapper) {
        this.countryRepository = countryRepository;
        this.countryMapper = countryMapper;
    }

    @Transactional(readOnly=true)
    public List<CountryDTO> findByCriteria(CountryCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.countryMapper.toDto(this.countryRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<CountryDTO> findByCriteria(CountryCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.countryRepository.findAll(specification, page).map(arg_0 -> ((CountryMapper)this.countryMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(CountryCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.countryRepository.count(specification);
    }

    protected Specification<Country> createSpecification(CountryCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Country_.id));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), Country_.name));
            }
            if (criteria.getIso() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getIso(), Country_.iso));
            }
            if (criteria.getIso3() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getIso3(), Country_.iso3));
            }
            if (criteria.getNumCode() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getNumCode(), Country_.numCode));
            }
            if (criteria.getPhoneCode() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getPhoneCode(), Country_.phoneCode));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), Country_.status));
            }
        }
        return specification;
    }
}

