/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.service;

import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.AppUser_;
import com.upl.fazorstarclub.domain.Country_;
import com.upl.fazorstarclub.domain.State_;
import com.upl.fazorstarclub.repository.AppUserRepository;
import com.upl.fazorstarclub.service.criteria.AppUserCriteria;
import com.upl.fazorstarclub.service.dto.AppUserDTO;
import com.upl.fazorstarclub.service.dto.AppUserDetailDTO;
import com.upl.fazorstarclub.service.mapper.AppUserDetailMapper;
import com.upl.fazorstarclub.service.mapper.AppUserMapper;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class AppUserQueryService
extends QueryService<AppUser> {
    private final Logger log = LoggerFactory.getLogger(AppUserQueryService.class);
    private final AppUserRepository appUserRepository;
    private final AppUserMapper appUserMapper;
    private final AppUserDetailMapper appUserDetailMapper;

    public AppUserQueryService(AppUserRepository appUserRepository, AppUserMapper appUserMapper, AppUserDetailMapper appUserDetailMapper) {
        this.appUserRepository = appUserRepository;
        this.appUserMapper = appUserMapper;
        this.appUserDetailMapper = appUserDetailMapper;
    }

    @Transactional(readOnly=true)
    public List<AppUserDTO> findByCriteria(AppUserCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.appUserMapper.toDto(this.appUserRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<AppUserDetailDTO> findByCriteria(AppUserCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        List appUserDTOs = this.appUserDetailMapper.toDto(this.appUserRepository.findAll(specification, page.getSort()).stream().distinct().collect(Collectors.toList()));
        int start = (int)page.getOffset();
        int end = start + page.getPageSize() > appUserDTOs.size() ? appUserDTOs.size() : start + page.getPageSize();
        return new PageImpl(appUserDTOs.subList(start, end), page, (long)appUserDTOs.size());
    }

    @Transactional(readOnly=true)
    public long countByCriteria(AppUserCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.appUserRepository.count(specification);
    }

    protected Specification<AppUser> createSpecification(AppUserCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), AppUser_.id));
            }
            if (criteria.getEmail() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getEmail(), AppUser_.email));
            }
            if (criteria.getPassword() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPassword(), AppUser_.password));
            }
            if (criteria.getUserName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getUserName(), AppUser_.userName));
            }
            if (criteria.getMobileNumber() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMobileNumber(), AppUser_.mobileNumber));
            }
            if (criteria.getProfilePhotoPath() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getProfilePhotoPath(), AppUser_.profilePhotoPath));
            }
            if (criteria.getRole() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getRole(), AppUser_.role));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), AppUser_.status));
            }
            if (criteria.getPincode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPincode(), AppUser_.pincode));
            }
            if (criteria.getCity() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCity(), AppUser_.city));
            }
            if (criteria.getStreet() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getStreet(), AppUser_.street));
            }
            if (criteria.getDistrict() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDistrict(), AppUser_.district));
            }
            if (criteria.getLatitude() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getLatitude(), AppUser_.latitude));
            }
            if (criteria.getLongitude() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getLongitude(), AppUser_.longitude));
            }
            if (criteria.getCountryId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getCountryId(), root -> root.join(AppUser_.country, JoinType.LEFT).get(Country_.id)));
            }
            if (criteria.getStateId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getStateId(), root -> root.join(AppUser_.state, JoinType.LEFT).get(State_.id)));
            }
            if (criteria.getParentId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getParentId(), root -> root.join(AppUser_.parent, JoinType.LEFT).get(AppUser_.id)));
            }
        }
        return specification;
    }
}

