/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.security.okta;

import com.upl.fazorstarclub.security.okta.AuthInfo;
import com.upl.fazorstarclub.security.okta.MobileAuthInfo;
import com.upl.fazorstarclub.security.okta.OktaAuth;
import com.upl.fazorstarclub.security.okta.OktaUser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class OktaSecurity {
    @Value(value="${application.oauth.web.redirect-base-uri:}")
    private String webRedirectBaseUrl;
    @Value(value="${application.oauth.web.issuer-url:}")
    private String webIssuerUrl;
    @Value(value="${application.oauth.web.client-id:}")
    private String webClientId;
    @Value(value="${application.oauth.web.client-secret:}")
    private String webClientSecret;
    @Value(value="${application.oauth.mobile.redirect-base-uri:}")
    private String mobileRedirectBaseUrl;
    @Value(value="${application.oauth.mobile.issuer-url:}")
    private String mobileIssuerUrl;
    @Value(value="${application.oauth.mobile.client-id:}")
    private String mobileClientId;
    @Value(value="${application.oauth.mobile.client-secret:}")
    private String mobileClientSecret;
    HttpHeaders headers = new HttpHeaders();
    final Logger log = LoggerFactory.getLogger(OktaSecurity.class);

    public OktaUser authenticate(String authCode) {
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.add((Object)"grant_type", (Object)"authorization_code");
        data.add((Object)"redirect_uri", (Object)(this.webRedirectBaseUrl + "/sign-in"));
        data.add((Object)"code", (Object)authCode);
        this.headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        this.headers.setBasicAuth(this.webClientId, this.webClientSecret);
        this.headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((Object)data, (MultiValueMap)this.headers);
        OktaAuth response = (OktaAuth)restTemplate.exchange(this.webIssuerUrl + "/oauth2/v1/token", HttpMethod.POST, entity, OktaAuth.class, new Object[0]).getBody();
        assert (response != null);
        return this.getUserInfo(response.getAccessToken(), this.webIssuerUrl);
    }

    private OktaUser getUserInfo(String accessToken, String issuerUrl) {
        RestTemplate restTemplate = new RestTemplate();
        this.headers.setBearerAuth(accessToken);
        HttpEntity entity = new HttpEntity((Object)"", (MultiValueMap)this.headers);
        return (OktaUser)restTemplate.exchange(issuerUrl + "/oauth2/v1/userinfo", HttpMethod.GET, entity, OktaUser.class, new Object[0]).getBody();
    }

    public AuthInfo getAuthInfo() {
        HashMap<String, String> loginUrlParams = new HashMap<String, String>();
        byte[] randomString = new byte[7];
        new Random().nextBytes(randomString);
        loginUrlParams.put("client_id", this.webClientId);
        loginUrlParams.put("redirect_uri", this.webRedirectBaseUrl + "/sign-in");
        loginUrlParams.put("state", new String(randomString, StandardCharsets.UTF_8));
        loginUrlParams.put("response_type", "code");
        loginUrlParams.put("response_mode", "query");
        loginUrlParams.put("scope", "openid profile email");
        String loginUrl = this.webIssuerUrl + "/oauth2/v1/authorize?" + loginUrlParams.entrySet().stream().map(p -> {
            try {
                return URLEncoder.encode((String)p.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)p.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
        }).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
        HashMap<String, String> logoutUrlParams = new HashMap<String, String>();
        logoutUrlParams.put("fromURI", this.webRedirectBaseUrl + "/sign-out");
        String logoutUrl = this.webIssuerUrl + "/login/signout?" + logoutUrlParams.entrySet().stream().map(p -> {
            try {
                return URLEncoder.encode((String)p.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)p.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
        }).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
        AuthInfo authInfo = new AuthInfo();
        authInfo.setLoginUrl(loginUrl);
        authInfo.setLogoutUrl(logoutUrl);
        return authInfo;
    }

    public MobileAuthInfo getMobileAuthInfo() {
        MobileAuthInfo mobileAuthInfo = new MobileAuthInfo();
        mobileAuthInfo.setClientId(this.mobileClientId);
        mobileAuthInfo.setClientSecret(this.mobileClientSecret);
        mobileAuthInfo.setIssuerUrl(this.mobileIssuerUrl);
        mobileAuthInfo.setLoginRedirectUrl(this.mobileRedirectBaseUrl + ":/callback");
        mobileAuthInfo.setLogoutRedirectUrl(this.mobileRedirectBaseUrl + ":/logoutCallback");
        return mobileAuthInfo;
    }

    public OktaUser authenticateMobile(String accessToken) {
        return this.getUserInfo(accessToken, this.mobileIssuerUrl);
    }
}

