/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.security.jwt;

import com.upl.fazorstarclub.service.AppUserLoginService;
import com.upl.fazorstarclub.service.dto.AppUserLoginDTO;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import tech.jhipster.config.JHipsterProperties;

@Component
public class TokenProvider {
    private final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    private static final String AUTHORITIES_KEY = "auth";
    private Key key;
    private long tokenValidityInMilliseconds;
    private long tokenValidityInMillisecondsForRememberMe;
    private final JHipsterProperties jHipsterProperties;
    private final AppUserLoginService appUserLoginService;

    public TokenProvider(JHipsterProperties jHipsterProperties, AppUserLoginService appUserLoginService) {
        this.jHipsterProperties = jHipsterProperties;
        this.appUserLoginService = appUserLoginService;
    }

    @PostConstruct
    public void init() {
        byte[] keyBytes;
        String secret = this.jHipsterProperties.getSecurity().getAuthentication().getJwt().getSecret();
        if (!StringUtils.isEmpty((Object)secret)) {
            this.log.warn("Warning: the JWT key used is not Base64-encoded. We recommend using the `jhipster.security.authentication.jwt.base64-secret` key for optimum security.");
            keyBytes = secret.getBytes(StandardCharsets.UTF_8);
        } else {
            this.log.debug("Using a Base64-encoded JWT secret key");
            keyBytes = (byte[])Decoders.BASE64.decode((Object)this.jHipsterProperties.getSecurity().getAuthentication().getJwt().getBase64Secret());
        }
        this.key = Keys.hmacShaKeyFor((byte[])keyBytes);
        this.tokenValidityInMilliseconds = 1000L * this.jHipsterProperties.getSecurity().getAuthentication().getJwt().getTokenValidityInSeconds();
        this.tokenValidityInMillisecondsForRememberMe = 1000L * this.jHipsterProperties.getSecurity().getAuthentication().getJwt().getTokenValidityInSecondsForRememberMe();
    }

    public String createToken(Authentication authentication) {
        String authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
        long now = new Date().getTime();
        Date validity = new Date(now + this.tokenValidityInMilliseconds);
        return Jwts.builder().setSubject(authentication.getName()).claim(AUTHORITIES_KEY, (Object)authorities).signWith(this.key, SignatureAlgorithm.HS512).setExpiration(validity).compact();
    }

    public Authentication getAuthentication(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.key).parseClaimsJws(token).getBody();
        Collection authorities = Arrays.stream(claims.get((Object)AUTHORITIES_KEY).toString().split(",")).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        User principal = new User(claims.getSubject(), "", authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)token, authorities);
    }

    public boolean validateToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.key).parseClaimsJws(authToken);
            return this.validateUserLogin(authToken);
        }
        catch (JwtException | IllegalArgumentException e) {
            this.log.info("Invalid JWT token.");
            this.log.trace("Invalid JWT token trace.", e);
            return false;
        }
    }

    private boolean validateUserLogin(String authToken) {
        Optional appUserLogin = this.appUserLoginService.findByToken(authToken);
        return appUserLogin.isPresent() && ((AppUserLoginDTO)appUserLogin.get()).getLogoutDate() == null && ((AppUserLoginDTO)appUserLogin.get()).getAppUser() != null && ((AppUserLoginDTO)appUserLogin.get()).getAppUser().isStatus() != false;
    }
}

