/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.security;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static Optional<String> getCurrentUserLogin() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return Optional.ofNullable(SecurityUtils.extractPrincipal((Authentication)securityContext.getAuthentication()));
    }

    private static String extractPrincipal(Authentication authentication) {
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            UserDetails springSecurityUser = (UserDetails)authentication.getPrincipal();
            return springSecurityUser.getUsername();
        }
        if (authentication.getPrincipal() instanceof String) {
            return (String)authentication.getPrincipal();
        }
        return null;
    }

    public static Optional<String> getCurrentUserJWT() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return Optional.ofNullable(securityContext.getAuthentication()).filter(authentication -> authentication.getCredentials() instanceof String).map(authentication -> (String)authentication.getCredentials());
    }

    public static boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && SecurityUtils.getAuthorities((Authentication)authentication).noneMatch("ROLE_ANONYMOUS"::equals);
    }

    public static boolean hasCurrentUserAnyOfAuthorities(String ... authorities) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && SecurityUtils.getAuthorities((Authentication)authentication).anyMatch(authority -> Arrays.asList(authorities).contains(authority));
    }

    public static boolean hasCurrentUserNoneOfAuthorities(String ... authorities) {
        return !SecurityUtils.hasCurrentUserAnyOfAuthorities((String[])authorities);
    }

    public static boolean hasCurrentUserThisAuthority(String authority) {
        return SecurityUtils.hasCurrentUserAnyOfAuthorities((String[])new String[]{authority});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCurrentUserInRole(String authority) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) return false;
        if (!SecurityUtils.getAuthorities((Authentication)authentication).anyMatch(authority::equals)) return false;
        return true;
    }

    private static Stream<String> getAuthorities(Authentication authentication) {
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority);
    }
}

