/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.repository;

import com.upl.fazorstarclub.domain.DataCollection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface DataCollectionRepository
extends JpaRepository<DataCollection, Long>,
JpaSpecificationExecutor<DataCollection> {
    @Query(value="WITH data_collections AS ( SELECT *, ROW_NUMBER() OVER(PARTITION BY user_farm_id ORDER BY created_date DESC) AS row_num FROM data_collections) SELECT * FROM data_collections WHERE row_num = 1 and status = true and data_collections.user_farm_id in :userFarmIds", nativeQuery=true)
    public List<DataCollection> findAllTopDataCollectionRecords(@Param(value="userFarmIds") List<Long> var1);

    public Optional<DataCollection> findTopByUserFarmIdOrderByCreatedDateDesc(Long var1);

    @Query(value="select data_collections.* from data_collections join user_farms on data_collections.user_farm_id=user_farms.id where data_collections.status=true and user_farms.status=true group by user_farms.state_id", nativeQuery=true)
    public List<DataCollection> findAllByRegion();

    public List<DataCollection> findAllByUserFarmIdIn(List<Long> var1);
}

