/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.fazorstarclub.domain.AbstractAuditingEntity;
import com.upl.fazorstarclub.domain.AppUser;
import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.Irrigation;
import com.upl.fazorstarclub.domain.PreviousCrop;
import com.upl.fazorstarclub.domain.SeedVariety;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.domain.enumeration.MarketType;
import com.upl.fazorstarclub.domain.enumeration.TypeOfSoil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="user_farms")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class UserFarm
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @Column(name="planting_date")
    private Instant plantingDate;
    @Column(name="plot_name")
    private String plotName;
    @Column(name="latitude", precision=10, scale=8)
    private BigDecimal latitude;
    @Column(name="longitude", precision=11, scale=8)
    private BigDecimal longitude;
    @Column(name="inter_row")
    private Double interRow;
    @Column(name="distributor_name")
    private String distributorName;
    @Enumerated(value=EnumType.STRING)
    @Column(name="market_type")
    private MarketType marketType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type_of_soil")
    private TypeOfSoil typeOfSoil;
    @ManyToOne
    private SeedVariety seedVariety;
    @ManyToOne
    private PreviousCrop previousCrop;
    @ManyToOne
    @JsonIgnoreProperties(value={"parent"}, allowSetters=true)
    private Irrigation irrigation;
    @Column(name="status")
    private Boolean status;
    @Column(name="pincode")
    private String pincode;
    @Column(name="city")
    private String city;
    @Column(name="street")
    private String street;
    @Column(name="district")
    private String district;
    @ManyToOne
    private Country country;
    @ManyToOne
    private State state;
    @ManyToOne
    private AppUser appUser;

    public Long getId() {
        return this.id;
    }

    public UserFarm id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Instant getPlantingDate() {
        return this.plantingDate;
    }

    public void setPlantingDate(Instant plantingDate) {
        this.plantingDate = plantingDate;
    }

    public String getPlotName() {
        return this.plotName;
    }

    public UserFarm plotName(String plotName) {
        this.setPlotName(plotName);
        return this;
    }

    public void setPlotName(String plotName) {
        this.plotName = plotName;
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public UserFarm latitude(BigDecimal latitude) {
        this.setLatitude(latitude);
        return this;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public UserFarm longitude(BigDecimal longitude) {
        this.setLongitude(longitude);
        return this;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public Double getInterRow() {
        return this.interRow;
    }

    public UserFarm interRow(Double interRow) {
        this.setInterRow(interRow);
        return this;
    }

    public void setInterRow(Double interRow) {
        this.interRow = interRow;
    }

    public String getDistributorName() {
        return this.distributorName;
    }

    public UserFarm distributorName(String distributorName) {
        this.setDistributorName(distributorName);
        return this;
    }

    public void setDistributorName(String distributorName) {
        this.distributorName = distributorName;
    }

    public MarketType getMarketType() {
        return this.marketType;
    }

    public UserFarm marketType(MarketType marketType) {
        this.setMarketType(marketType);
        return this;
    }

    public void setMarketType(MarketType marketType) {
        this.marketType = marketType;
    }

    public TypeOfSoil getTypeOfSoil() {
        return this.typeOfSoil;
    }

    public UserFarm typeOfSoil(TypeOfSoil typeOfSoil) {
        this.setTypeOfSoil(typeOfSoil);
        return this;
    }

    public void setTypeOfSoil(TypeOfSoil typeOfSoil) {
        this.typeOfSoil = typeOfSoil;
    }

    public SeedVariety getSeedVariety() {
        return this.seedVariety;
    }

    public void setSeedVariety(SeedVariety seedVariety) {
        this.seedVariety = seedVariety;
    }

    public UserFarm seedVariety(SeedVariety seedVariety) {
        this.setSeedVariety(seedVariety);
        return this;
    }

    public PreviousCrop getPreviousCrop() {
        return this.previousCrop;
    }

    public void setPreviousCrop(PreviousCrop previousCrop) {
        this.previousCrop = previousCrop;
    }

    public UserFarm previousCrop(PreviousCrop previousCrop) {
        this.setPreviousCrop(previousCrop);
        return this;
    }

    public Irrigation getIrrigation() {
        return this.irrigation;
    }

    public void setIrrigation(Irrigation irrigation) {
        this.irrigation = irrigation;
    }

    public UserFarm irrigation(Irrigation irrigation) {
        this.setIrrigation(irrigation);
        return this;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getPincode() {
        return this.pincode;
    }

    public void setPincode(String pincode) {
        this.pincode = pincode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public AppUser getAppUser() {
        return this.appUser;
    }

    public void setAppUser(AppUser appUser) {
        this.appUser = appUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserFarm)) {
            return false;
        }
        return this.id != null && this.id.equals(((UserFarm)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "UserFarm [id=" + this.id + ", plantingDate=" + this.plantingDate + ", plotName=" + this.plotName + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", interRow=" + this.interRow + ", distributorName=" + this.distributorName + ", marketType=" + this.marketType + ", typeOfSoil=" + this.typeOfSoil + ", seedVariety=" + this.seedVariety + ", previousCrop=" + this.previousCrop + ", irrigation=" + this.irrigation + ", status=" + this.status + ", pincode=" + this.pincode + ", city=" + this.city + ", street=" + this.street + ", district=" + this.district + ", country=" + this.country + ", state=" + this.state + ", appUser=" + this.appUser + "]";
    }
}

