/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.fazorstarclub.domain.AbstractAuditingEntity;
import com.upl.fazorstarclub.domain.TopicImage;
import com.upl.fazorstarclub.domain.enumeration.TopicCategory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="topics")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Topic
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @Column(name="status")
    private Boolean status;
    @Column(name="topic_name")
    private String topicName;
    @Lob
    @Column(name="description")
    private String description;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="topic_category", nullable=false)
    private TopicCategory topicCategory;
    @OneToMany(mappedBy="topics")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @JsonIgnoreProperties(value={"topics"}, allowSetters=true)
    private Set<TopicImage> topicImages = new HashSet();

    public Long getId() {
        return this.id;
    }

    public Topic id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public Topic status(Boolean status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Topic topicName(String topicName) {
        this.setTopicName(topicName);
        return this;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getDescription() {
        return this.description;
    }

    public Topic description(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TopicCategory getTopicCategory() {
        return this.topicCategory;
    }

    public Topic topicCategory(TopicCategory topicCategory) {
        this.setTopicCategory(topicCategory);
        return this;
    }

    public void setTopicCategory(TopicCategory topicCategory) {
        this.topicCategory = topicCategory;
    }

    public Set<TopicImage> getTopicImages() {
        return this.topicImages;
    }

    public void setTopicImages(Set<TopicImage> topicImages) {
        if (this.topicImages != null) {
            this.topicImages.forEach(i -> i.setTopics(null));
        }
        if (topicImages != null) {
            topicImages.forEach(i -> i.setTopics(this));
        }
        this.topicImages = topicImages;
    }

    public Topic topicImages(Set<TopicImage> topicImages) {
        this.setTopicImages(topicImages);
        return this;
    }

    public Topic addTopicImages(TopicImage topicImage) {
        this.topicImages.add(topicImage);
        topicImage.setTopics(this);
        return this;
    }

    public Topic removeTopicImages(TopicImage topicImage) {
        this.topicImages.remove(topicImage);
        topicImage.setTopics(null);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Topic)) {
            return false;
        }
        return this.id != null && this.id.equals(((Topic)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "Topic{id=" + this.getId() + ", status='" + this.getStatus() + "', topicName='" + this.getTopicName() + "', description='" + this.getDescription() + "', topicCategory='" + this.getTopicCategory() + "'}";
    }
}

