/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.fazorstarclub.domain.NewsImage;
import com.upl.fazorstarclub.domain.enumeration.TypeOfCategory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="news")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class News
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type_of_category")
    private TypeOfCategory typeOfCategory;
    @Column(name="title")
    private String title;
    @Lob
    @Column(name="description")
    private String description;
    @Column(name="status")
    private Boolean status;
    @OneToMany(mappedBy="news")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @JsonIgnoreProperties(value={"news"}, allowSetters=true)
    private Set<NewsImage> newsImages = new HashSet();

    public Long getId() {
        return this.id;
    }

    public News id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TypeOfCategory getTypeOfCategory() {
        return this.typeOfCategory;
    }

    public News typeOfCategory(TypeOfCategory typeOfCategory) {
        this.setTypeOfCategory(typeOfCategory);
        return this;
    }

    public void setTypeOfCategory(TypeOfCategory typeOfCategory) {
        this.typeOfCategory = typeOfCategory;
    }

    public String getTitle() {
        return this.title;
    }

    public News title(String title) {
        this.setTitle(title);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public News description(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public News status(Boolean status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Set<NewsImage> getNewsImages() {
        return this.newsImages;
    }

    public void setNewsImages(Set<NewsImage> newsImages) {
        if (this.newsImages != null) {
            this.newsImages.forEach(i -> i.setNews(null));
        }
        if (newsImages != null) {
            newsImages.forEach(i -> i.setNews(this));
        }
        this.newsImages = newsImages;
    }

    public News newsImages(Set<NewsImage> newsImages) {
        this.setNewsImages(newsImages);
        return this;
    }

    public News addNewsImages(NewsImage newsImage) {
        this.newsImages.add(newsImage);
        newsImage.setNews(this);
        return this;
    }

    public News removeNewsImages(NewsImage newsImage) {
        this.newsImages.remove(newsImage);
        newsImage.setNews(null);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof News)) {
            return false;
        }
        return this.id != null && this.id.equals(((News)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "News{id=" + this.getId() + ", typeOfCategory='" + this.getTypeOfCategory() + "', title='" + this.getTitle() + "', description='" + this.getDescription() + "', status='" + this.getStatus() + "'}";
    }
}

