/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.fazorstarclub.domain.AbstractAuditingEntity;
import com.upl.fazorstarclub.domain.MasterDisease;
import com.upl.fazorstarclub.domain.UserFarm;
import com.upl.fazorstarclub.domain.enumeration.LevelOfPressure;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="diseases")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Disease
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @Column(name="name")
    private String name;
    @Column(name="status")
    private Boolean status;
    @Column(name="latitude", precision=10, scale=8)
    private BigDecimal latitude;
    @Column(name="longitude", precision=11, scale=8)
    private BigDecimal longitude;
    @Enumerated(value=EnumType.STRING)
    @Column(name="level_of_pressure")
    private LevelOfPressure levelOfPressure;
    @ManyToOne
    private MasterDisease masterDisease;
    @ManyToOne
    @JsonIgnoreProperties(value={"seedVariety", "previousCrop", "irrigation"}, allowSetters=true)
    private UserFarm userFarm;

    public Long getId() {
        return this.id;
    }

    public Disease id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Disease name(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public Disease status(Boolean status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public LevelOfPressure getLevelOfPressure() {
        return this.levelOfPressure;
    }

    public Disease levelOfPressure(LevelOfPressure levelOfPressure) {
        this.setLevelOfPressure(levelOfPressure);
        return this;
    }

    public void setLevelOfPressure(LevelOfPressure levelOfPressure) {
        this.levelOfPressure = levelOfPressure;
    }

    public MasterDisease getMasterDisease() {
        return this.masterDisease;
    }

    public void setMasterDisease(MasterDisease masterDisease) {
        this.masterDisease = masterDisease;
    }

    public Disease masterDisease(MasterDisease masterDisease) {
        this.setMasterDisease(masterDisease);
        return this;
    }

    public UserFarm getUserFarm() {
        return this.userFarm;
    }

    public void setUserFarm(UserFarm userFarm) {
        this.userFarm = userFarm;
    }

    public Disease userFarm(UserFarm userFarm) {
        this.setUserFarm(userFarm);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Disease)) {
            return false;
        }
        return this.id != null && this.id.equals(((Disease)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "Disease{id=" + this.getId() + ", name='" + this.getName() + "', status='" + this.getStatus() + "', levelOfPressure='" + this.getLevelOfPressure() + "', latitude='" + this.getLatitude() + "', longitude='" + this.getLongitude() + "'}";
    }
}

