/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.domain;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.fazorstarclub.domain.AbstractAuditingEntity;
import com.upl.fazorstarclub.domain.Country;
import com.upl.fazorstarclub.domain.State;
import com.upl.fazorstarclub.domain.enumeration.Role;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Where;

@Entity
@Table(name="app_users")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class AppUser
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Column(name="email", nullable=false, unique=true)
    private String email;
    @NotNull
    @Column(name="password", nullable=false)
    private String password;
    @NotNull
    @Column(name="user_name")
    private String userName;
    @Column(name="id_number", unique=true)
    private String idNumber;
    @NotNull
    @Column(name="mobile_number", nullable=false, unique=true)
    private String mobileNumber;
    @Column(name="profile_photo_path")
    private String profilePhotoPath;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="role", nullable=false)
    private Role role;
    @Column(name="status")
    private Boolean status;
    @Column(name="pincode")
    private String pincode;
    @Column(name="city")
    private String city;
    @Column(name="street")
    private String street;
    @Column(name="district")
    private String district;
    @Column(name="latitude", precision=10, scale=8)
    private BigDecimal latitude;
    @Column(name="longitude", precision=11, scale=8)
    private BigDecimal longitude;
    @ManyToOne
    private Country country;
    @Column(name="company_name")
    private String companyName;
    @Column(name="address")
    private String address;
    @Column(name="agreement_number", unique=true)
    private String agreementNumber;
    @ManyToOne
    @JsonIgnoreProperties(value={"appUsers"})
    private State state;
    @ManyToOne
    @JsonBackReference
    @JsonIgnoreProperties(value={"children"})
    private AppUser parent;
    @JsonIgnoreProperties(value={"parent"})
    @OneToMany(mappedBy="parent")
    @Where(clause="status = 1")
    private Set<AppUser> children = new HashSet();

    public Long getId() {
        return this.id;
    }

    public AppUser id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public AppUser email(String email) {
        this.setEmail(email);
        return this;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public AppUser password(String password) {
        this.setPassword(password);
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public AppUser mobileNumber(String mobileNumber) {
        this.setMobileNumber(mobileNumber);
        return this;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public AppUser getParent() {
        return this.parent;
    }

    public void setParent(AppUser parent) {
        this.parent = parent;
    }

    public Set<AppUser> getChildren() {
        return this.children;
    }

    public void setChildren(Set<AppUser> children) {
        this.children = children;
    }

    public AppUser role(Role role) {
        this.setRole(role);
        return this;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public Boolean isStatus() {
        return this.status;
    }

    public AppUser status(Boolean status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getPincode() {
        return this.pincode;
    }

    public AppUser pincode(String pincode) {
        this.setPincode(pincode);
        return this;
    }

    public void setPincode(String pincode) {
        this.pincode = pincode;
    }

    public String getCity() {
        return this.city;
    }

    public AppUser city(String city) {
        this.setCity(city);
        return this;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStreet() {
        return this.street;
    }

    public AppUser street(String street) {
        this.setStreet(street);
        return this;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getDistrict() {
        return this.district;
    }

    public AppUser district(String district) {
        this.setDistrict(district);
        return this;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public AppUser latitude(BigDecimal latitude) {
        this.setLatitude(latitude);
        return this;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public AppUser longitude(BigDecimal longitude) {
        this.setLongitude(longitude);
        return this;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public AppUser country(Country country) {
        this.setCountry(country);
        return this;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public AppUser state(State state) {
        this.setState(state);
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAgreementNumber() {
        return this.agreementNumber;
    }

    public void setAgreementNumber(String agreementNumber) {
        this.agreementNumber = agreementNumber;
    }

    public String getProfilePhotoPath() {
        return this.profilePhotoPath;
    }

    public void setProfilePhotoPath(String profilePhotoPath) {
        this.profilePhotoPath = profilePhotoPath;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppUser)) {
            return false;
        }
        return this.id != null && this.id.equals(((AppUser)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "AppUser [id=" + this.id + ", email=" + this.email + ", password=" + this.password + ", userName=" + this.userName + ", idNumber=" + this.idNumber + ", mobileNumber=" + this.mobileNumber + ", profilePhotoPath=" + this.profilePhotoPath + ", role=" + this.role + ", status=" + this.status + ", pincode=" + this.pincode + ", city=" + this.city + ", street=" + this.street + ", district=" + this.district + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", country=" + this.country + ", companyName=" + this.companyName + ", address=" + this.address + ", agreementNumber=" + this.agreementNumber + ", state=" + this.state + ", parent=" + this.parent + ", children=" + this.children + "]";
    }
}

