/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfiguration {
    @Value(value="${application.swagger.host:}")
    private String host;

    @Bean
    public Docket apiwithAuth() {
        return new Docket(DocumentationType.SWAGGER_2).ignoredParameterTypes(new Class[]{AuthenticationPrincipal.class}).host(this.host).groupName("api-with-authentication").select().apis(Predicates.not((Predicate)RequestHandlerSelectors.basePackage((String)"org.springframework.boot"))).paths(PathSelectors.any()).build().securitySchemes((List)Lists.newArrayList((Object[])new ApiKey[]{this.apiKey()})).securityContexts(Arrays.asList(this.securityContext()));
    }

    private ApiKey apiKey() {
        return new ApiKey("apiKey", "Authorization", "header");
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.any()).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Arrays.asList(new SecurityReference("apiKey", authorizationScopes));
    }
}

