/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.config;

import com.upl.fazorstarclub.security.jwt.JWTConfigurer;
import com.upl.fazorstarclub.security.jwt.TokenProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Import(value={SecurityProblemSupport.class})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final TokenProvider tokenProvider;
    private final SecurityProblemSupport problemSupport;

    public SecurityConfiguration(TokenProvider tokenProvider, SecurityProblemSupport problemSupport) {
        this.tokenProvider = tokenProvider;
        this.problemSupport = problemSupport;
    }

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.problemSupport).accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).headers().contentSecurityPolicy("default-src 'self'; frame-src 'self' data:; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://storage.googleapis.com; style-src 'self' 'unsafe-inline'; img-src 'self' data:; font-src 'self' data:").and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().permissionsPolicy().policy("camera=(), fullscreen=(self), geolocation=(), gyroscope=(), magnetometer=(), microphone=(), midi=(), payment=(), sync-xhr=()").and().frameOptions().deny().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(HttpMethod.OPTIONS, new String[]{"/api/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/countries"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/states"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/image/**"})).permitAll().antMatchers(new String[]{"/api/login"})).permitAll().antMatchers(new String[]{"/api/reset-password"})).permitAll().antMatchers(new String[]{"/api/update-password"})).permitAll().antMatchers(new String[]{"/api/auth-info"})).permitAll().antMatchers(new String[]{"/api/mobiles/**"})).permitAll().antMatchers(new String[]{"/api/authenticate"})).permitAll().antMatchers(new String[]{"/api/user/signup"})).permitAll().antMatchers(new String[]{"/api/app-users/user-type"})).permitAll().antMatchers(new String[]{"/api/user-farm/market-type"})).permitAll().antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/health/**"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/prometheus"})).permitAll().antMatchers(new String[]{"/management/**"})).hasAuthority("ADMIN").and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private JWTConfigurer securityConfigurerAdapter() {
        return new JWTConfigurer(this.tokenProvider);
    }

    @Bean
    public PasswordEncoder encoder() {
        return new BCryptPasswordEncoder(11);
    }
}

