/*
 * Decompiled with CFR 0.152.
 */
package com.upl.fazorstarclub.aop.logging;

import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@Aspect
public class LoggingAspect {
    private final Environment env;

    public LoggingAspect(Environment env) {
        this.env = env;
    }

    @Pointcut(value="within(@org.springframework.stereotype.Repository *) || within(@org.springframework.stereotype.Service *) || within(@org.springframework.web.bind.annotation.RestController *)")
    public void springBeanPointcut() {
    }

    @Pointcut(value="within(com.upl.fazorstarclub.repository..*) || within(com.upl.fazorstarclub.service..*) || within(com.upl.fazorstarclub.web.rest..*)")
    public void applicationPackagePointcut() {
    }

    private Logger logger(JoinPoint joinPoint) {
        return LoggerFactory.getLogger((String)joinPoint.getSignature().getDeclaringTypeName());
    }

    @AfterThrowing(pointcut="applicationPackagePointcut() && springBeanPointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            this.logger(joinPoint).error("Exception in {}() with cause = '{}' and exception = '{}'", new Object[]{joinPoint.getSignature().getName(), e.getCause() != null ? e.getCause() : "NULL", e.getMessage(), e});
        } else {
            this.logger(joinPoint).error("Exception in {}() with cause = {}", (Object)joinPoint.getSignature().getName(), e.getCause() != null ? e.getCause() : "NULL");
        }
    }

    @Around(value="applicationPackagePointcut() && springBeanPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Logger log = this.logger((JoinPoint)joinPoint);
        if (log.isDebugEnabled()) {
            log.debug("Enter: {}() with argument[s] = {}", (Object)joinPoint.getSignature().getName(), (Object)Arrays.toString(joinPoint.getArgs()));
        }
        try {
            Object result = joinPoint.proceed();
            if (log.isDebugEnabled()) {
                log.debug("Exit: {}() with result = {}", (Object)joinPoint.getSignature().getName(), result);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            log.error("Illegal argument: {} in {}()", (Object)Arrays.toString(joinPoint.getArgs()), (Object)joinPoint.getSignature().getName());
            throw e;
        }
    }
}

